/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher;

import org.neo4j.cypher.SyntaxException;
import org.neo4j.cypher.internal.v3_6.util.test_helpers.CypherFunSuite;
import org.scalactic.Equality;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.matchers.MatcherFactory1;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001m2A!\u0001\u0002\u0001\u0013\t\u00192+\u001f8uCb,\u0005pY3qi&|g\u000eV3ti*\u00111\u0001B\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005\u00151\u0011!\u00028f_RR'\"A\u0004\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001Q\u0001CA\u0006\u0015\u001b\u0005a!BA\u0007\u000f\u00031!Xm\u001d;`Q\u0016d\u0007/\u001a:t\u0015\ty\u0001#\u0001\u0003vi&d'BA\t\u0013\u0003\u001118g\u0018\u001c\u000b\u0005M\u0011\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005Ua!AD\"za\",'OR;o'VLG/\u001a\u0005\u0006/\u0001!\t\u0001G\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0001\"A\u0007\u0001\u000e\u0003\tAQ\u0001\b\u0001\u0005\nu\t1\"Z9vC2\u001cFO]5oOR\u0011aD\r\t\u0005?\u00112C&D\u0001!\u0015\t\t#%\u0001\u0005nCR\u001c\u0007.\u001a:t\u0015\t\u0019c!A\u0005tG\u0006d\u0017\r^3ti&\u0011Q\u0005\t\u0002\u0010\u001b\u0006$8\r[3s\r\u0006\u001cGo\u001c:zcA\u0011qEK\u0007\u0002Q)\t\u0011&A\u0003tG\u0006d\u0017-\u0003\u0002,Q\t\u0019\u0011I\\=\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0005=2\u0011!C:dC2\f7\r^5d\u0013\t\tdF\u0001\u0005FcV\fG.\u001b;z\u0011\u0015\u00194\u00041\u00015\u0003\u0005\u0019\bCA\u001b9\u001d\t9c'\u0003\u00028Q\u00051\u0001K]3eK\u001aL!!\u000f\u001e\u0003\rM#(/\u001b8h\u0015\t9\u0004\u0006")
public class SyntaxExceptionTest
extends CypherFunSuite {
    public MatcherFactory1<Object, Equality> org$neo4j$cypher$SyntaxExceptionTest$$equalString(String s) {
        return this.equal(new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(s)).stripMargin())).lines().mkString(System.lineSeparator()));
    }

    public SyntaxExceptionTest() {
        this.test("caret renders correctly for single line query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SyntaxExceptionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SyntaxException ex = new SyntaxException("msg", "query", 3);
                String msg = ex.getMessage();
                this.$outer.convertToStringShouldWrapper(msg).should(this.$outer.org$neo4j$cypher$SyntaxExceptionTest$$equalString("msg\n        |\"query\"\n        |    ^"), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("caret renders correctly under X for multiline query using \\n", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SyntaxExceptionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SyntaxException ex = new SyntaxException("msg", "line 1\nline 2 X marks the spot", 14);
                String msg = ex.getMessage();
                this.$outer.convertToStringShouldWrapper(msg).should(this.$outer.org$neo4j$cypher$SyntaxExceptionTest$$equalString("msg\n        |\"line 2 X marks the spot\"\n        |        ^"), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("caret renders correctly under X for multiline query using \\r\\n", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SyntaxExceptionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SyntaxException ex = new SyntaxException("msg", "line 1\r\nline 2 X marks the spot", 15);
                String msg = ex.getMessage();
                this.$outer.convertToStringShouldWrapper(msg).should(this.$outer.org$neo4j$cypher$SyntaxExceptionTest$$equalString("msg\n        |\"line 2 X marks the spot\"\n        |        ^"), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("caret renders at the end when offset is too large", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SyntaxExceptionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SyntaxException ex = new SyntaxException("msg", "line 1\r\nline 2", 1000);
                String msg = ex.getMessage();
                this.$outer.convertToStringShouldWrapper(msg).should(this.$outer.org$neo4j$cypher$SyntaxExceptionTest$$equalString("msg\n        |\"line 2\"\n        |       ^"), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("caret renders at the end when query is empty", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SyntaxExceptionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SyntaxException ex = new SyntaxException("msg", "", 0);
                String msg = ex.getMessage();
                this.$outer.convertToStringShouldWrapper(msg).should(this.$outer.org$neo4j$cypher$SyntaxExceptionTest$$equalString("msg\n        |\"\"\n        | ^"), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("no caret renders when no offset is given", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SyntaxExceptionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SyntaxException ex = new SyntaxException("msg", "query", (Option)None$.MODULE$);
                String msg = ex.getMessage();
                this.$outer.convertToStringShouldWrapper(msg).should(this.$outer.org$neo4j$cypher$SyntaxExceptionTest$$equalString("msg"), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

