/*
 * Decompiled with CFR 0.152.
 */
package io.graphoenix.rabbitmq.handler.after;

import io.graphoenix.core.handler.DocumentManager;
import io.graphoenix.spi.graphql.Definition;
import io.graphoenix.spi.graphql.operation.Operation;
import io.graphoenix.spi.graphql.type.FieldDefinition;
import io.graphoenix.spi.graphql.type.ObjectType;
import io.graphoenix.spi.handler.OperationAfterHandler;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonCollectors;
import java.lang.invoke.CallSite;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.rabbitmq.OutboundMessage;
import reactor.rabbitmq.Sender;

@ApplicationScoped
@Priority(value=2147483397)
public class MutationSendHandler
implements OperationAfterHandler {
    public static final int MUTATION_SEND_HANDLER_PRIORITY = 2147483397;
    private final DocumentManager documentManager;
    private final Sender sender;

    @Inject
    public MutationSendHandler(DocumentManager documentManager, Sender sender) {
        this.documentManager = documentManager;
        this.sender = sender;
    }

    public Mono<JsonValue> mutation(Operation operation, JsonValue jsonValue) {
        ObjectType operationType = this.documentManager.getOperationTypeOrError(operation);
        Map typeJsonObjectListMap = operation.getFields().stream().filter(field -> !operationType.getField(field.getName()).isInvokeField()).flatMap(field -> this.buildTypeJsonObjectEntryStream(operationType.getField(field.getName()), (JsonValue)field.getArguments())).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
        return this.sender.send((Publisher)Flux.fromIterable(typeJsonObjectListMap.entrySet()).map(entry -> new OutboundMessage("graphoenix.subscription", (String)entry.getKey(), ((JsonArray)((List)entry.getValue()).stream().collect(JsonCollectors.toJsonArray())).toString().getBytes()))).thenReturn((Object)jsonValue);
    }

    private Stream<Map.Entry<String, JsonObject>> buildTypeJsonObjectEntryStream(FieldDefinition fieldDefinition, JsonValue jsonValue) {
        if (jsonValue == null || jsonValue.getValueType().equals((Object)JsonValue.ValueType.NULL)) {
            return Stream.empty();
        }
        Definition fieldTypeDefinition = this.documentManager.getFieldTypeDefinition(fieldDefinition);
        if (fieldTypeDefinition.isObject() && !fieldTypeDefinition.isContainer()) {
            String packageName = fieldTypeDefinition.getPackageNameOrError();
            String typeName = fieldTypeDefinition.getName();
            if (jsonValue.getValueType().equals((Object)JsonValue.ValueType.ARRAY)) {
                return jsonValue.asJsonArray().stream().flatMap(item -> this.buildTypeJsonObjectEntryStream(fieldDefinition, (JsonValue)item));
            }
            if (jsonValue.getValueType().equals((Object)JsonValue.ValueType.OBJECT) && jsonValue.asJsonObject().containsKey((Object)"list")) {
                return jsonValue.asJsonObject().getJsonArray("list").stream().flatMap(item -> this.buildTypeJsonObjectEntryStream(fieldDefinition, (JsonValue)item));
            }
            if (jsonValue.getValueType().equals((Object)JsonValue.ValueType.OBJECT) && jsonValue.asJsonObject().containsKey((Object)"input")) {
                return Stream.concat(Stream.of(new AbstractMap.SimpleEntry<CallSite, JsonObject>((CallSite)((Object)(packageName + "." + typeName)), (JsonObject)jsonValue.asJsonObject().getJsonObject("input").entrySet().stream().filter(entry -> ((String)entry.getKey()).equals("where") || this.documentManager.getFieldTypeDefinition(fieldTypeDefinition.asObject().getField((String)entry.getKey())).isLeaf()).map(entry -> new AbstractMap.SimpleEntry<String, JsonValue>((String)entry.getKey(), (JsonValue)entry.getValue())).collect(JsonCollectors.toJsonObject()))), jsonValue.asJsonObject().getJsonObject("input").entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("where")).filter(entry -> !this.documentManager.getFieldTypeDefinition(fieldTypeDefinition.asObject().getField((String)entry.getKey())).isLeaf()).flatMap(entry -> this.buildTypeJsonObjectEntryStream(fieldTypeDefinition.asObject().getField((String)entry.getKey()), (JsonValue)entry.getValue())));
            }
            return Stream.concat(Stream.of(new AbstractMap.SimpleEntry<CallSite, JsonObject>((CallSite)((Object)(packageName + "." + typeName)), (JsonObject)jsonValue.asJsonObject().entrySet().stream().filter(entry -> ((String)entry.getKey()).equals("where") || this.documentManager.getFieldTypeDefinition(fieldTypeDefinition.asObject().getField((String)entry.getKey())).isLeaf()).map(entry -> new AbstractMap.SimpleEntry<String, JsonValue>((String)entry.getKey(), (JsonValue)entry.getValue())).collect(JsonCollectors.toJsonObject()))), jsonValue.asJsonObject().entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("where")).filter(entry -> !this.documentManager.getFieldTypeDefinition(fieldTypeDefinition.asObject().getField((String)entry.getKey())).isLeaf()).flatMap(entry -> this.buildTypeJsonObjectEntryStream(fieldTypeDefinition.asObject().getField((String)entry.getKey()), (JsonValue)entry.getValue())));
        }
        return Stream.empty();
    }
}

