/*
 * Decompiled with CFR 0.152.
 */
package io.graphoenix.rabbitmq.produces;

import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import io.graphoenix.rabbitmq.config.RabbitMQConfig;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import reactor.core.publisher.Mono;
import reactor.rabbitmq.RabbitFlux;
import reactor.rabbitmq.Receiver;
import reactor.rabbitmq.ReceiverOptions;
import reactor.rabbitmq.Sender;
import reactor.rabbitmq.SenderOptions;

@ApplicationScoped
public class RabbitMQProducer {
    private final Mono<Connection> connectionMono;

    @Inject
    public RabbitMQProducer(RabbitMQConfig rabbitMQConfig) {
        this.connectionMono = this.createConnectionMono(rabbitMQConfig);
    }

    public Mono<Connection> createConnectionMono(RabbitMQConfig rabbitMQConfig) {
        ConnectionFactory connectionFactory = new ConnectionFactory();
        connectionFactory.useNio();
        connectionFactory.setHost(rabbitMQConfig.getHost());
        connectionFactory.setPort(rabbitMQConfig.getPort().intValue());
        connectionFactory.setUsername(rabbitMQConfig.getUsername());
        connectionFactory.setPassword(rabbitMQConfig.getPassword());
        connectionFactory.setVirtualHost(rabbitMQConfig.getVirtualHost());
        connectionFactory.setRequestedChannelMax(rabbitMQConfig.getRequestedChannelMax().intValue());
        connectionFactory.setRequestedFrameMax(rabbitMQConfig.getRequestedFrameMax().intValue());
        connectionFactory.setRequestedHeartbeat(rabbitMQConfig.getRequestedHeartbeat().intValue());
        connectionFactory.setConnectionTimeout(rabbitMQConfig.getConnectionTimeout().intValue());
        connectionFactory.setHandshakeTimeout(rabbitMQConfig.getHandshakeTimeout().intValue());
        connectionFactory.setShutdownTimeout(rabbitMQConfig.getShutdownTimeout().intValue());
        connectionFactory.setAutomaticRecoveryEnabled(rabbitMQConfig.getAutomaticRecovery().booleanValue());
        connectionFactory.setTopologyRecoveryEnabled(rabbitMQConfig.getTopologyRecovery().booleanValue());
        connectionFactory.setNetworkRecoveryInterval(rabbitMQConfig.getNetworkRecoveryInterval().longValue());
        connectionFactory.setChannelRpcTimeout(rabbitMQConfig.getChannelRpcTimeout().intValue());
        connectionFactory.setChannelShouldCheckRpcResponseType(rabbitMQConfig.getChannelShouldCheckRpcResponseType().booleanValue());
        connectionFactory.setWorkPoolTimeout(rabbitMQConfig.getWorkPoolTimeout().intValue());
        return Mono.fromCallable(() -> ((ConnectionFactory)connectionFactory).newConnection()).cache();
    }

    @Produces
    @ApplicationScoped
    public Sender sender() {
        return RabbitFlux.createSender((SenderOptions)new SenderOptions().connectionMono(this.connectionMono));
    }

    @Produces
    @ApplicationScoped
    public Receiver receiver() {
        return RabbitFlux.createReceiver((ReceiverOptions)new ReceiverOptions().connectionMono(this.connectionMono));
    }
}

