/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.api;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.graphper.api.Node;
import org.graphper.def.FlatPoint;
import org.graphper.util.Asserts;

public class Assemble
implements Serializable {
    private static final long serialVersionUID = 8476339759307801893L;
    private double width;
    private double height;
    private Map<Node, CellPos> cells;

    private Assemble() {
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public Set<Node> getCells() {
        return this.cells.keySet();
    }

    public double horOffset(Node cell) {
        CellPos cellPos = this.cells.get(cell);
        Asserts.illegalArgument(cellPos == null, "Can not found cell offset info");
        return cellPos.horOffset;
    }

    public double verOffset(Node cell) {
        CellPos cellPos = this.cells.get(cell);
        Asserts.illegalArgument(cellPos == null, "Can not found cell offset info");
        return cellPos.verOffset;
    }

    public FlatPoint size() {
        return new FlatPoint(this.height, this.width);
    }

    public static AssembleBuilder builder() {
        return new AssembleBuilder();
    }

    private static class CellPos
    implements Serializable {
        private static final long serialVersionUID = -4804439305833411858L;
        private final double horOffset;
        private final double verOffset;

        public CellPos(double horOffset, double verOffset) {
            this.horOffset = horOffset * 72.0;
            this.verOffset = verOffset * 72.0;
        }
    }

    public static class AssembleBuilder {
        private double width;
        private double height;
        private volatile LinkedHashMap<Node, CellPos> cells;

        private AssembleBuilder() {
        }

        public AssembleBuilder width(double width) {
            Asserts.illegalArgument(width <= 0.0, "Width " + width + " must greater than 0");
            this.width = width * 72.0;
            return this;
        }

        public AssembleBuilder height(double height) {
            Asserts.illegalArgument(height <= 0.0, "Height " + height + " must greater than 0");
            this.height = height * 72.0;
            return this;
        }

        public synchronized AssembleBuilder addCell(double horOffset, double verOffset, Node cell) {
            Asserts.nullArgument(cell, "Cell");
            if (this.cells == null) {
                this.cells = new LinkedHashMap();
            }
            this.cells.put(cell, new CellPos(horOffset, verOffset));
            return this;
        }

        public synchronized Assemble build() {
            Assemble assemble = new Assemble();
            assemble.width = this.width;
            assemble.height = this.height;
            if (this.cells != null) {
                assemble.cells = new LinkedHashMap<Node, CellPos>(this.cells);
            } else {
                assemble.cells = Collections.emptyMap();
            }
            return assemble;
        }
    }
}

