/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.api;

import java.io.Serializable;
import org.graphper.api.Assemble;
import org.graphper.api.ClusterAttrs;
import org.graphper.api.GraphContainer;
import org.graphper.api.Html;
import org.graphper.api.attributes.ClusterStyle;
import org.graphper.api.attributes.Color;
import org.graphper.api.attributes.Labeljust;
import org.graphper.api.attributes.Labelloc;
import org.graphper.def.FlatPoint;
import org.graphper.util.Asserts;

public class Cluster
extends GraphContainer
implements Serializable {
    private static final long serialVersionUID = 5027532737058187995L;
    private final ClusterAttrs clusterAttrs;

    private Cluster(ClusterAttrs clusterAttrs) {
        this.clusterAttrs = clusterAttrs;
    }

    public ClusterAttrs clusterAttrs() {
        return this.clusterAttrs;
    }

    public static ClusterBuilder builder() {
        return new ClusterBuilder();
    }

    public static class IntegrationClusterBuilder<G extends GraphContainer, B extends GraphContainer.GraphContainerBuilder<G, B>>
    extends AbstractClusterBuilder<IntegrationClusterBuilder<G, B>> {
        private final B parentBuilder;

        IntegrationClusterBuilder(B parentBuilder) {
            Asserts.nullArgument(parentBuilder, "parentBuilder");
            this.parentBuilder = parentBuilder;
        }

        public B endClus() {
            Cluster cluster = (Cluster)this.build();
            ((GraphContainer.GraphContainerBuilder)this.parentBuilder).cluster(cluster);
            return this.parentBuilder;
        }

        @Override
        protected IntegrationClusterBuilder<G, B> self() {
            return this;
        }
    }

    public static class ClusterBuilder
    extends AbstractClusterBuilder<ClusterBuilder> {
        private ClusterBuilder() {
        }

        @Override
        protected ClusterBuilder self() {
            return this;
        }

        public ClusterBuilder clone() throws CloneNotSupportedException {
            ClusterBuilder repl = (ClusterBuilder)super.clone();
            repl.container = this.copy();
            repl.clusterAttrs = ((Cluster)repl.container).clusterAttrs;
            this.supplyFields(repl.container);
            return repl;
        }
    }

    public static abstract class AbstractClusterBuilder<B extends GraphContainer.GraphContainerBuilder<Cluster, B>>
    extends GraphContainer.GraphContainerBuilder<Cluster, B>
    implements Cloneable {
        protected ClusterAttrs clusterAttrs = new ClusterAttrs();

        protected AbstractClusterBuilder() {
        }

        public B label(String label) {
            this.clusterAttrs.label = label;
            return this.self();
        }

        public B labelloc(Labelloc labelloc) {
            Asserts.nullArgument((Object)labelloc, "labelloc");
            this.clusterAttrs.labelloc = labelloc;
            return this.self();
        }

        public B labeljust(Labeljust labeljust) {
            Asserts.nullArgument((Object)labeljust, "labeljust");
            this.clusterAttrs.labeljust = labeljust;
            return this.self();
        }

        public B style(ClusterStyle style) {
            this.clusterAttrs.style = style;
            return this.self();
        }

        public B bgColor(Color bgColor) {
            this.clusterAttrs.bgColor = bgColor;
            return this.self();
        }

        public B color(Color color) {
            this.clusterAttrs.color = color;
            return this.self();
        }

        public B fontColor(Color fontColor) {
            this.clusterAttrs.fontColor = fontColor;
            return this.self();
        }

        public B fontName(String fontName) {
            Asserts.nullArgument(fontName, "fontName");
            this.clusterAttrs.fontName = fontName;
            return this.self();
        }

        public B margin(double margin) {
            return this.margin(margin, margin);
        }

        public B margin(double horMargin, double verMargin) {
            Asserts.illegalArgument(horMargin < 0.0, "Horizontal margin (" + horMargin + ") can not less than 0");
            Asserts.illegalArgument(verMargin < 0.0, "Vertical margin (" + verMargin + ") can not less than 0");
            this.clusterAttrs.margin = new FlatPoint.UnmodifyFlatPoint(verMargin * 72.0, horMargin * 72.0);
            return this.self();
        }

        public B fontSize(double fontSize) {
            Asserts.illegalArgument(fontSize < 0.0, "fontSize (" + fontSize + ") can not less than 0");
            this.clusterAttrs.fontSize = fontSize;
            return this.self();
        }

        public B href(String href) {
            this.clusterAttrs.href = href;
            return this.self();
        }

        public B penWidth(double penWidth) {
            Asserts.illegalArgument(penWidth < 0.0, "penWidth can not be less than 0");
            this.clusterAttrs.penWidth = penWidth;
            return this.self();
        }

        public B table(Html.Table table) {
            this.clusterAttrs.table = table;
            return this.self();
        }

        public B assemble(Assemble assemble) {
            this.clusterAttrs.assemble = assemble;
            return this.self();
        }

        @Override
        protected Cluster newContainer() {
            return new Cluster(this.clusterAttrs);
        }

        @Override
        protected Cluster copy() {
            return new Cluster(this.clusterAttrs.clone());
        }
    }
}

