/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.api;

import java.io.Serializable;
import java.util.Objects;
import org.graphper.api.Assemble;
import org.graphper.api.Html;
import org.graphper.api.attributes.Tend;
import org.graphper.def.FlatPoint;
import org.graphper.util.Asserts;

public class FloatLabel
implements Serializable {
    private static final long serialVersionUID = 8788129136334958892L;
    private final String label;
    private final Tend tend;
    private final Html.Table table;
    private final Assemble assemble;
    private final float fontSize;
    private final double lengthRatio;
    private final FlatPoint offset;

    private FloatLabel(String label, float fontSize, double lengthRatio, Tend tend, FlatPoint offset, Html.Table table, Assemble assemble) {
        Asserts.illegalArgument(label == null && table == null && assemble == null, "Empty Float Label");
        Asserts.illegalArgument(fontSize < 0.0f, "Float label can not less than 0");
        this.label = label;
        this.fontSize = fontSize;
        this.lengthRatio = lengthRatio;
        this.tend = tend;
        this.offset = offset;
        this.table = table;
        this.assemble = assemble;
    }

    public String getLabel() {
        return this.label;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public Tend getTend() {
        return this.tend;
    }

    public double getLengthRatio() {
        return this.lengthRatio;
    }

    public FlatPoint getOffset() {
        return this.offset;
    }

    public Html.Table getTable() {
        return this.table;
    }

    public Assemble getAssemble() {
        return this.assemble;
    }

    public boolean ignoreTextLabel() {
        return this.table != null || this.assemble != null;
    }

    public static FloatLabelBuilder builder() {
        return new FloatLabelBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FloatLabel that = (FloatLabel)o;
        return Float.compare(that.fontSize, this.fontSize) == 0 && Double.compare(that.lengthRatio, this.lengthRatio) == 0 && Objects.equals(this.label, that.label) && Objects.equals(this.table, that.table) && Objects.equals(this.assemble, that.assemble) && Objects.equals(this.offset, that.offset);
    }

    public int hashCode() {
        return Objects.hash(this.label, this.table, this.assemble, Float.valueOf(this.fontSize), this.lengthRatio, this.offset);
    }

    public static class FloatLabelBuilder {
        private String label;
        private float fontSize = 14.0f;
        private Tend tend;
        private double lengthRatio;
        private FlatPoint offset;
        private Html.Table table;
        private Assemble assemble;

        private FloatLabelBuilder() {
        }

        public FloatLabelBuilder label(String label) {
            Asserts.nullArgument(label, "floatLabel");
            this.label = label;
            return this;
        }

        public FloatLabelBuilder fontSize(float fontSize) {
            Asserts.illegalArgument(fontSize < 0.0f, "fontSize (" + fontSize + ") can not less than 0");
            this.fontSize = fontSize;
            return this;
        }

        public FloatLabelBuilder lengthRatio(double lengthRatio) {
            this.lengthRatio = lengthRatio;
            return this;
        }

        public FloatLabelBuilder offset(double sizeRatio) {
            return this.offset(sizeRatio, sizeRatio);
        }

        public FloatLabelBuilder offset(double heightRatio, double widthRatio) {
            this.offset = new FlatPoint(heightRatio, widthRatio);
            return this;
        }

        public FloatLabelBuilder tend(Tend tend) {
            this.tend = tend;
            return this;
        }

        public FloatLabelBuilder table(Html.Table table) {
            this.table = table;
            return this;
        }

        public FloatLabelBuilder assemble(Assemble assemble) {
            this.assemble = assemble;
            return this;
        }

        public FloatLabel build() {
            return new FloatLabel(this.label, this.fontSize, this.lengthRatio, this.tend, this.offset, this.table, this.assemble);
        }
    }
}

