/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.api;

import java.io.Serializable;
import java.util.Objects;
import org.graphper.api.Assemble;
import org.graphper.api.Html;
import org.graphper.api.attributes.Color;
import org.graphper.api.attributes.Labeljust;
import org.graphper.api.attributes.Labelloc;
import org.graphper.api.attributes.Layout;
import org.graphper.api.attributes.Rankdir;
import org.graphper.api.attributes.Splines;
import org.graphper.def.FlatPoint;
import org.graphper.util.FontUtils;

public class GraphAttrs
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -1741433881093744063L;
    Color bgColor;
    Splines splines = Splines.ROUNDED;
    Color fontColor = Color.BLACK;
    Rankdir rankdir = Rankdir.rankdir(System.getProperty("rankdir"));
    Layout layout = Layout.DOT;
    double nodeSep = 36.0;
    String label;
    String fontName = FontUtils.DEFAULT_FONT;
    Labelloc labelloc = Labelloc.BOTTOM;
    Labeljust labeljust = Labeljust.CENTER;
    int nslimit = 100000;
    int nslimit1 = Integer.MAX_VALUE;
    double rankSep = 36.0;
    FlatPoint scale = new FlatPoint(1.0, 1.0);
    FlatPoint margin = new FlatPoint(20.0, 20.0);
    int mclimit = 8;
    double fontSize = 36.0;
    boolean compound = false;
    boolean showGrid = false;
    String href;
    Html.Table table;
    Assemble assemble;

    public Splines getSplines() {
        return this.splines;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public Rankdir getRankdir() {
        return this.rankdir;
    }

    public Layout getLayout() {
        return this.layout;
    }

    public double getNodeSep() {
        return this.nodeSep;
    }

    public String getFontName() {
        return this.fontName;
    }

    public String getLabel() {
        return this.label;
    }

    public Labelloc getLabelloc() {
        return this.labelloc;
    }

    public Labeljust getLabeljust() {
        return this.labeljust;
    }

    public int getNslimit() {
        return this.nslimit;
    }

    public int getNslimit1() {
        return this.nslimit1;
    }

    public double getRankSep() {
        return this.rankSep;
    }

    public FlatPoint getScale() {
        return this.scale;
    }

    public int getMclimit() {
        return this.mclimit;
    }

    public FlatPoint getMargin() {
        return this.margin;
    }

    public double getFontSize() {
        return this.fontSize;
    }

    public boolean isCompound() {
        return this.compound;
    }

    public boolean isShowGrid() {
        return this.showGrid;
    }

    public String getHref() {
        return this.href;
    }

    public Html.Table getTable() {
        return this.table;
    }

    public Assemble getAssemble() {
        return this.assemble;
    }

    public GraphAttrs clone() {
        try {
            return (GraphAttrs)super.clone();
        }
        catch (CloneNotSupportedException ignore) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphAttrs that = (GraphAttrs)o;
        return Double.compare(that.nodeSep, this.nodeSep) == 0 && this.nslimit == that.nslimit && this.nslimit1 == that.nslimit1 && Double.compare(that.rankSep, this.rankSep) == 0 && this.mclimit == that.mclimit && Double.compare(that.fontSize, this.fontSize) == 0 && this.compound == that.compound && this.showGrid == that.showGrid && Objects.equals(this.bgColor, that.bgColor) && this.splines == that.splines && Objects.equals(this.fontColor, that.fontColor) && this.rankdir == that.rankdir && this.layout == that.layout && Objects.equals(this.label, that.label) && Objects.equals(this.fontName, that.fontName) && this.labelloc == that.labelloc && this.labeljust == that.labeljust && Objects.equals(this.scale, that.scale) && Objects.equals(this.margin, that.margin) && Objects.equals(this.href, that.href) && Objects.equals(this.table, that.table) && Objects.equals(this.assemble, that.assemble);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bgColor, this.splines, this.fontColor, this.rankdir, this.layout, this.nodeSep, this.label, this.fontName, this.labelloc, this.labeljust, this.nslimit, this.nslimit1, this.rankSep, this.scale, this.margin, this.mclimit, this.fontSize, this.compound, this.showGrid, this.href, this.table, this.assemble});
    }

    public String toString() {
        return "GraphAttrs{bgColor=" + this.bgColor + ", splines=" + (Object)((Object)this.splines) + ", fontColor=" + this.fontColor + ", rankdir=" + (Object)((Object)this.rankdir) + ", layout=" + (Object)((Object)this.layout) + ", nodeSep=" + this.nodeSep + ", label='" + this.label + '\'' + ", fontName='" + this.fontName + '\'' + ", labelloc=" + (Object)((Object)this.labelloc) + ", labeljust=" + (Object)((Object)this.labeljust) + ", nslimit=" + this.nslimit + ", nslimit1=" + this.nslimit1 + ", rankSep=" + this.rankSep + ", scale=" + this.scale + ", margin=" + this.margin + ", mclimit=" + this.mclimit + ", fontSize=" + this.fontSize + ", compound=" + this.compound + ", showGrid=" + this.showGrid + ", href='" + this.href + '\'' + ", table='" + this.table + '\'' + ", assemble=" + this.assemble + '}';
    }
}

