/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.graphper.api.Cluster;
import org.graphper.api.Graphviz;
import org.graphper.api.Line;
import org.graphper.api.LineAttrs;
import org.graphper.api.Node;
import org.graphper.api.NodeAttrs;
import org.graphper.api.Subgraph;
import org.graphper.def.BiConcatIterable;
import org.graphper.def.VertexIndex;
import org.graphper.util.Asserts;
import org.graphper.util.ClassUtils;
import org.graphper.util.CollectionUtils;

public abstract class GraphContainer
extends VertexIndex {
    protected String id;
    protected volatile List<Subgraph> subgraphs;
    protected volatile List<Cluster> clusters;
    protected volatile Set<Line> lines;
    protected volatile Set<Node> nodes;
    protected volatile Map<String, Object> nodeAttrsMap;
    protected volatile Map<String, Object> lineAttrsMap;

    public String id() {
        return this.id;
    }

    public boolean isGraphviz() {
        return this instanceof Graphviz;
    }

    public boolean isSubgraph() {
        return this instanceof Subgraph;
    }

    public boolean isCluster() {
        return this instanceof Cluster;
    }

    public boolean isEmpty() {
        if (this.absoluteEmpty()) {
            return true;
        }
        for (Subgraph subgraph : this.subgraphs()) {
            if (subgraph.isEmpty()) continue;
            return false;
        }
        for (Cluster cluster : this.clusters()) {
            if (cluster.isEmpty()) continue;
            return false;
        }
        return CollectionUtils.isEmpty(this.nodes) && CollectionUtils.isEmpty(this.lines);
    }

    public boolean absoluteEmpty() {
        return CollectionUtils.isEmpty(this.subgraphs) && CollectionUtils.isEmpty(this.clusters) && CollectionUtils.isEmpty(this.nodes) && CollectionUtils.isEmpty(this.lines);
    }

    public List<Subgraph> subgraphs() {
        return CollectionUtils.isNotEmpty(this.subgraphs) ? Collections.unmodifiableList(this.subgraphs) : Collections.emptyList();
    }

    public List<Cluster> clusters() {
        return CollectionUtils.isNotEmpty(this.clusters) ? Collections.unmodifiableList(this.clusters) : Collections.emptyList();
    }

    public Iterable<Node> nodes() {
        if (CollectionUtils.isEmpty(this.subgraphs) && CollectionUtils.isEmpty(this.clusters)) {
            return CollectionUtils.isEmpty(this.nodes) ? Collections.emptyList() : Collections.unmodifiableSet(this.nodes);
        }
        ArrayList<Iterable<Node>> iterables = null;
        if (CollectionUtils.isNotEmpty(this.nodes)) {
            iterables = new ArrayList<Iterable<Node>>(1);
            iterables.add(this.nodes);
        }
        for (Subgraph subgraph : this.subgraphs()) {
            if (iterables == null) {
                iterables = new ArrayList(1);
            }
            iterables.add(subgraph.nodes());
        }
        for (Cluster cluster : this.clusters()) {
            if (iterables == null) {
                iterables = new ArrayList(1);
            }
            iterables.add(cluster.nodes());
        }
        if (CollectionUtils.isEmpty(iterables)) {
            return Collections.emptyList();
        }
        return new BiConcatIterable<Node>((Collection<Iterable<Node>>)iterables);
    }

    public Set<Node> directNodes() {
        return CollectionUtils.isEmpty(this.nodes) ? Collections.emptySet() : Collections.unmodifiableSet(this.nodes);
    }

    public int nodeNum() {
        int n = CollectionUtils.isNotEmpty(this.nodes) ? this.nodes.size() : 0;
        for (Subgraph subgraph : this.subgraphs()) {
            n += subgraph.nodeNum();
        }
        for (Cluster cluster : this.clusters()) {
            n += cluster.nodeNum();
        }
        return n;
    }

    public Iterable<Line> lines() {
        if (CollectionUtils.isEmpty(this.subgraphs) && CollectionUtils.isEmpty(this.clusters)) {
            return CollectionUtils.isEmpty(this.lines) ? Collections.emptyList() : Collections.unmodifiableSet(this.lines);
        }
        ArrayList<Iterable<Line>> iterables = null;
        if (CollectionUtils.isNotEmpty(this.lines)) {
            iterables = new ArrayList<Iterable<Line>>(1);
            iterables.add(this.lines);
        }
        for (Subgraph subgraph : this.subgraphs()) {
            if (iterables == null) {
                iterables = new ArrayList(1);
            }
            iterables.add(subgraph.lines());
        }
        for (Cluster cluster : this.clusters()) {
            if (iterables == null) {
                iterables = new ArrayList(1);
            }
            iterables.add(cluster.lines());
        }
        if (CollectionUtils.isEmpty(iterables)) {
            return Collections.emptyList();
        }
        return new BiConcatIterable<Line>((Collection<Iterable<Line>>)iterables);
    }

    public Set<Line> directLines() {
        return CollectionUtils.isEmpty(this.lines) ? Collections.emptySet() : Collections.unmodifiableSet(this.lines);
    }

    public int lineNum() {
        int n = CollectionUtils.isNotEmpty(this.lines) ? this.lines.size() : 0;
        for (Subgraph subgraph : this.subgraphs()) {
            n += subgraph.lineNum();
        }
        for (Cluster cluster : this.clusters()) {
            n += cluster.lineNum();
        }
        return n;
    }

    public boolean containsNode(Node node) {
        if (CollectionUtils.isNotEmpty(this.nodes) && this.nodes.contains(node)) {
            return true;
        }
        for (Subgraph subgraph : this.subgraphs()) {
            if (!subgraph.containsNode(node)) continue;
            return true;
        }
        for (Cluster cluster : this.clusters()) {
            if (!cluster.containsNode(node)) continue;
            return true;
        }
        return false;
    }

    public boolean containsLine(Line line) {
        if (CollectionUtils.isNotEmpty(this.lines) && this.lines.contains(line)) {
            return true;
        }
        for (Subgraph subgraph : this.subgraphs()) {
            if (!subgraph.containsLine(line)) continue;
            return true;
        }
        for (Cluster cluster : this.clusters()) {
            if (!cluster.containsLine(line)) continue;
            return true;
        }
        return false;
    }

    public boolean isTransparent() {
        return this instanceof Subgraph && ((Subgraph)this).getRank() == null;
    }

    public Object getNodeAttr(String fieldName) {
        if (this.nodeAttrsMap == null) {
            return null;
        }
        return this.nodeAttrsMap.get(fieldName);
    }

    public Object getLineAttr(String fieldName) {
        if (this.lineAttrsMap == null) {
            return null;
        }
        return this.lineAttrsMap.get(fieldName);
    }

    public boolean haveNodeTemp() {
        return this.nodeAttrsMap != null;
    }

    public boolean haveLineTemp() {
        return this.lineAttrsMap != null;
    }

    public boolean haveChildCluster() {
        return CollectionUtils.isNotEmpty(this.clusters);
    }

    synchronized void addSubgraph(Subgraph subgraph) {
        Asserts.nullArgument(subgraph, "subgraph");
        if (this.subgraphs == null) {
            this.subgraphs = new ArrayList<Subgraph>();
        }
        this.subgraphs.add(subgraph);
    }

    synchronized void addCluster(Cluster cluster) {
        Asserts.nullArgument(cluster, "cluster");
        if (this.clusters == null) {
            this.clusters = new ArrayList<Cluster>();
        }
        this.clusters.add(cluster);
    }

    synchronized void addLine(Line line) {
        Asserts.nullArgument(line, "line");
        if (this.lines == null) {
            this.lines = new TreeSet<Line>();
        }
        this.lines.add(line);
    }

    synchronized void addNode(Node node) {
        Asserts.nullArgument(node, "node");
        if (this.nodes == null) {
            this.nodes = new TreeSet<Node>();
        }
        this.nodes.add(node);
    }

    public static abstract class GraphContainerBuilder<G extends GraphContainer, B extends GraphContainerBuilder<G, B>> {
        protected volatile Map<String, Object> nodeAttrsMap;
        protected volatile Map<String, Object> lineAttrsMap;
        protected volatile G container;

        protected abstract B self();

        protected abstract G newContainer();

        public B id(String id) {
            ((GraphContainer)this.initContainer()).id = id;
            return this.self();
        }

        public B subgraph(Subgraph subgraph) {
            Asserts.nullArgument(subgraph, "subgraph");
            ((GraphContainer)this.initContainer()).addSubgraph(subgraph);
            return this.self();
        }

        public B cluster(Cluster cluster) {
            Asserts.nullArgument(cluster, "cluster");
            ((GraphContainer)this.initContainer()).addCluster(cluster);
            return this.self();
        }

        public Subgraph.IntegrationSubgraphBuilder<G, B> startSub() {
            return new Subgraph.IntegrationSubgraphBuilder(this);
        }

        public Cluster.IntegrationClusterBuilder<G, B> startClus() {
            return new Cluster.IntegrationClusterBuilder(this);
        }

        public B tempNode(Node node) {
            Asserts.nullArgument(node, "node");
            NodeAttrs nodeAttrs = node.nodeAttrs();
            if (nodeAttrs != null) {
                try {
                    this.nodeAttrsMap = ClassUtils.propValMap(nodeAttrs);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.self();
        }

        public B tempLine(Line line) {
            Asserts.nullArgument(line, "line");
            LineAttrs lineAttrs = line.lineAttrs();
            if (lineAttrs != null) {
                try {
                    this.lineAttrsMap = ClassUtils.propValMap(lineAttrs);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.self();
        }

        public B addNode(Node node) {
            Asserts.nullArgument(node, "node");
            ((GraphContainer)this.initContainer()).addNode(node);
            return this.self();
        }

        public B addNode(Node ... nodes) {
            Asserts.illegalArgument(nodes == null || nodes.length == 0, "nodes can not be empty");
            for (Node node : nodes) {
                if (node == null) continue;
                ((GraphContainer)this.initContainer()).addNode(node);
            }
            return this.self();
        }

        public B addLine(Node tail, Node head) {
            Asserts.nullArgument(tail, "tail");
            Asserts.nullArgument(head, "head");
            return this.addLine(Line.builder(tail, head).build());
        }

        public B addLine(Node ... nodes) {
            Asserts.illegalArgument(nodes == null || nodes.length == 0, "nodes can not be empty");
            Asserts.illegalArgument(nodes.length < 2, "nodes can not be less than 2");
            for (int i = 0; i < nodes.length - 1; ++i) {
                this.addLine(Line.builder(nodes[i], nodes[i + 1]).build());
            }
            return this.self();
        }

        public B addLine(Line line) {
            Asserts.nullArgument(line, "line");
            ((GraphContainer)this.initContainer()).addNode(line.head());
            ((GraphContainer)this.initContainer()).addNode(line.tail());
            ((GraphContainer)this.initContainer()).addLine(line);
            return this.self();
        }

        public G build() {
            G repl = this.copy();
            this.supplyFields(repl);
            return repl;
        }

        protected abstract G copy();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected G initContainer() {
            if (this.container == null) {
                GraphContainerBuilder graphContainerBuilder = this;
                synchronized (graphContainerBuilder) {
                    if (this.container == null) {
                        this.container = this.newContainer();
                    }
                }
            }
            return this.container;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void supplyFields(G repl) {
            G g = this.initContainer();
            ((GraphContainer)repl).id = ((GraphContainer)g).id;
            G g2 = g;
            synchronized (g2) {
                if (((GraphContainer)g).subgraphs != null) {
                    ((GraphContainer)repl).subgraphs = new ArrayList<Subgraph>(((GraphContainer)g).subgraphs);
                }
                if (((GraphContainer)g).clusters != null) {
                    ((GraphContainer)repl).clusters = new ArrayList<Cluster>(((GraphContainer)g).clusters);
                }
                if (((GraphContainer)g).nodes != null) {
                    ((GraphContainer)repl).nodes = new TreeSet<Node>(((GraphContainer)g).nodes);
                }
                if (((GraphContainer)g).lines != null) {
                    ((GraphContainer)repl).lines = new TreeSet<Line>(((GraphContainer)g).lines);
                }
            }
            if (this.nodeAttrsMap != null) {
                ((GraphContainer)repl).nodeAttrsMap = new HashMap<String, Object>(this.nodeAttrsMap);
            }
            if (this.lineAttrsMap != null) {
                ((GraphContainer)repl).lineAttrsMap = new HashMap<String, Object>(this.lineAttrsMap);
            }
        }
    }
}

