/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.api;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.graphper.api.Assemble;
import org.graphper.api.FileType;
import org.graphper.api.GraphAttrs;
import org.graphper.api.GraphContainer;
import org.graphper.api.GraphResource;
import org.graphper.api.Html;
import org.graphper.api.attributes.Color;
import org.graphper.api.attributes.Labeljust;
import org.graphper.api.attributes.Labelloc;
import org.graphper.api.attributes.Layout;
import org.graphper.api.attributes.Rankdir;
import org.graphper.api.attributes.Splines;
import org.graphper.def.FlatPoint;
import org.graphper.draw.ExecuteException;
import org.graphper.draw.common.CommonRenderEngine;
import org.graphper.util.Asserts;
import org.graphper.util.GraphvizUtils;

public class Graphviz
extends GraphContainer
implements Serializable {
    public static final long serialVersionUID = 7386714074818676956L;
    public static final int PIXEL = 72;
    public static final int MAX_DEPTH = 1000;
    private GraphAttrs graphAttrs;
    private Map<GraphContainer, GraphContainer> fatherRecord;
    private final boolean isDirected;
    private volatile GraphResource svg;

    private Graphviz(boolean isDirected, GraphAttrs graphAttrs) {
        this.graphAttrs = graphAttrs;
        this.isDirected = isDirected;
    }

    public GraphAttrs graphAttrs() {
        return this.graphAttrs;
    }

    public boolean isDirected() {
        return this.isDirected;
    }

    public GraphContainer father(GraphContainer container) {
        if (this.fatherRecord == null) {
            return null;
        }
        return this.fatherRecord.get(container);
    }

    public GraphContainer effectiveFather(GraphContainer container) {
        if (this.fatherRecord == null) {
            return null;
        }
        GraphContainer p = this.fatherRecord.get(container);
        while (p != null && p.isSubgraph()) {
            p = this.fatherRecord.get(p);
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphResource toSvg() throws ExecuteException {
        if (this.svg != null) {
            return this.svg;
        }
        Graphviz graphviz = this;
        synchronized (graphviz) {
            if (this.svg == null) {
                this.svg = this.toFile(null);
            }
        }
        return this.svg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toSvgStr() throws ExecuteException {
        try (GraphResource resource = this.toSvg();){
            Object object = this;
            synchronized (object) {
                this.svg = null;
            }
            object = new String(resource.bytes());
            return object;
        }
        catch (IOException e) {
            throw new ExecuteException(e);
        }
    }

    public GraphResource toFile(FileType fileType) throws ExecuteException {
        return CommonRenderEngine.getInstance().render(this, (Object)fileType);
    }

    public static GraphvizBuilder graph() {
        return new GraphvizBuilder(false);
    }

    public static GraphvizBuilder digraph() {
        return new GraphvizBuilder(true);
    }

    public static class GraphvizBuilder
    extends GraphContainer.GraphContainerBuilder<Graphviz, GraphvizBuilder>
    implements Cloneable {
        private GraphAttrs graphAttrs = new GraphAttrs();
        private final boolean isDirected;

        private GraphvizBuilder(boolean isDirected) {
            this.isDirected = isDirected;
        }

        private Graphviz newGraphviz() {
            return new Graphviz(this.isDirected, this.graphAttrs);
        }

        @Override
        protected GraphvizBuilder self() {
            return this;
        }

        @Override
        protected Graphviz newContainer() {
            Graphviz graphviz = this.newGraphviz();
            graphviz.graphAttrs = this.graphAttrs;
            return graphviz;
        }

        @Override
        protected Graphviz copy() {
            Graphviz graphviz = this.newGraphviz();
            graphviz.graphAttrs = this.graphAttrs.clone();
            return graphviz;
        }

        public GraphvizBuilder label(String label) {
            this.graphAttrs.label = label;
            return this.self();
        }

        public GraphvizBuilder labelloc(Labelloc labelloc) {
            Asserts.nullArgument((Object)labelloc, "labelloc");
            this.graphAttrs.labelloc = labelloc;
            return this.self();
        }

        public GraphvizBuilder labeljust(Labeljust labeljust) {
            Asserts.nullArgument((Object)labeljust, "labeljust");
            this.graphAttrs.labeljust = labeljust;
            return this.self();
        }

        public GraphvizBuilder fontName(String fontName) {
            Asserts.nullArgument(fontName, "fontName");
            this.graphAttrs.fontName = fontName;
            return this.self();
        }

        public GraphvizBuilder splines(Splines splines) {
            Asserts.nullArgument((Object)splines, "splines");
            this.graphAttrs.splines = splines;
            return this.self();
        }

        public GraphvizBuilder rankdir(Rankdir rankdir) {
            Asserts.nullArgument((Object)rankdir, "rankdir");
            this.graphAttrs.rankdir = rankdir;
            return this.self();
        }

        public GraphvizBuilder bgColor(Color bgColor) {
            this.graphAttrs.bgColor = bgColor;
            return this.self();
        }

        public GraphvizBuilder fontColor(Color fontColor) {
            Asserts.nullArgument(fontColor, "fontColor");
            this.graphAttrs.fontColor = fontColor;
            return this.self();
        }

        public GraphvizBuilder layout(Layout layout) {
            Asserts.nullArgument((Object)layout, "layout");
            this.graphAttrs.layout = layout;
            return this.self();
        }

        public GraphvizBuilder nodeSep(double nodeSep) {
            Asserts.illegalArgument(nodeSep < 0.0, "nodeSep (" + nodeSep + ") can not less than 0");
            this.graphAttrs.nodeSep = nodeSep * 72.0;
            return this.self();
        }

        public GraphvizBuilder nslimit(int nslimit) {
            Asserts.illegalArgument(nslimit < 0, "nslimit (" + nslimit + ") can not less than 0");
            this.graphAttrs.nslimit = nslimit;
            return this.self();
        }

        public GraphvizBuilder nslimit1(int nslimit1) {
            Asserts.illegalArgument(nslimit1 < 0, "nslimit (" + nslimit1 + ") can not less than 0");
            this.graphAttrs.nslimit1 = nslimit1;
            return this.self();
        }

        public GraphvizBuilder rankSep(double rankSep) {
            Asserts.illegalArgument(rankSep < 0.1, "ranksep (" + rankSep + ") can not less than 0.1");
            this.graphAttrs.rankSep = rankSep * 72.0;
            return this.self();
        }

        public GraphvizBuilder scale(double scale) {
            return this.scale(scale, scale);
        }

        public GraphvizBuilder scale(double horScale, double verScale) {
            Asserts.illegalArgument(horScale < 0.1, "Horizontal scale (" + horScale + ") can not less than 0.1");
            Asserts.illegalArgument(verScale < 0.1, "Vertical scale (" + verScale + ") can not less than 0.1");
            this.graphAttrs.scale = new FlatPoint.UnmodifyFlatPoint(horScale, verScale);
            return this.self();
        }

        public GraphvizBuilder margin(double margin) {
            return this.margin(margin, margin);
        }

        public GraphvizBuilder margin(double horMargin, double verMargin) {
            Asserts.illegalArgument(horMargin < 0.0, "Horizontal margin (" + horMargin + ") must be > 0");
            Asserts.illegalArgument(verMargin < 0.0, "Vertical margin (" + verMargin + ") must be > 0");
            this.graphAttrs.margin = new FlatPoint.UnmodifyFlatPoint(verMargin * 72.0, horMargin * 72.0);
            return this.self();
        }

        public GraphvizBuilder mclimit(int mclimit) {
            Asserts.illegalArgument(mclimit < 0, "mclimit (" + mclimit + ") can not less than 0");
            this.graphAttrs.mclimit = mclimit;
            return this.self();
        }

        public GraphvizBuilder fontSize(double fontSize) {
            Asserts.illegalArgument(fontSize < 0.0, "fontSize (" + fontSize + ") can not less than 0");
            this.graphAttrs.fontSize = fontSize;
            return this.self();
        }

        public GraphvizBuilder compound(boolean compound) {
            this.graphAttrs.compound = compound;
            return this.self();
        }

        public GraphvizBuilder showGrid(boolean showGrid) {
            this.graphAttrs.showGrid = showGrid;
            return this.self();
        }

        public GraphvizBuilder href(String href) {
            this.graphAttrs.href = href;
            return this.self();
        }

        public GraphvizBuilder table(Html.Table table) {
            this.graphAttrs.table = table;
            return this.self();
        }

        public GraphvizBuilder assemble(Assemble assemble) {
            this.graphAttrs.assemble = assemble;
            return this.self();
        }

        @Override
        public synchronized Graphviz build() {
            Graphviz graphviz = (Graphviz)super.build();
            HashSet<GraphContainer> path = new HashSet<GraphContainer>();
            HashSet<GraphContainer> accessStack = new HashSet<GraphContainer>();
            GraphvizUtils.dfs(1000, (boolean)Boolean.FALSE, path, accessStack, (GraphContainer)graphviz, (s, f) -> this.setFather(graphviz, (GraphContainer)f, (GraphContainer)s), (c, f) -> this.setFather(graphviz, (GraphContainer)f, (GraphContainer)c), null);
            return graphviz;
        }

        public GraphvizBuilder clone() throws CloneNotSupportedException {
            GraphvizBuilder repl = (GraphvizBuilder)super.clone();
            repl.container = this.copy();
            repl.graphAttrs = ((Graphviz)repl.container).graphAttrs;
            this.supplyFields(repl.container);
            return repl;
        }

        private void setFather(Graphviz graphviz, GraphContainer father, GraphContainer container) {
            if (graphviz.fatherRecord == null) {
                graphviz.fatherRecord = new HashMap();
            }
            Asserts.illegalArgument(container.absoluteEmpty(), "Graphviz have empty sub graph!");
            Asserts.illegalArgument(graphviz.fatherRecord.get(container) != null, "Graph Container is repeatedly set in Graphviz!");
            graphviz.fatherRecord.put(container, father);
        }
    }
}

