/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.graphper.api.attributes.Color;
import org.graphper.api.attributes.Labeljust;
import org.graphper.api.attributes.Labelloc;
import org.graphper.api.attributes.NodeShape;
import org.graphper.api.attributes.NodeShapeEnum;
import org.graphper.api.attributes.NodeStyle;
import org.graphper.util.Asserts;
import org.graphper.util.CollectionUtils;

public class Html {
    private Html() {
    }

    public static Table table() {
        return new Table();
    }

    public static Td td() {
        return new Td();
    }

    public static class Td
    extends Attrs<Td>
    implements Serializable {
        private static final long serialVersionUID = -8637141082571738828L;
        private Table table;
        private Integer border;
        private int rowSpan = 1;
        private int colSpan = 1;
        private String text;
        private Color fontColor;
        private String fontName;
        private double fontSize = 12.0;
        private NodeShape shape = NodeShapeEnum.RECT;

        @Override
        protected Td self() {
            return this;
        }

        public Td border(int border) {
            Asserts.illegalArgument(border < 0, "border can not be less than 0");
            this.border = border;
            return this;
        }

        public Td rowSpan(int rowSpan) {
            this.rowSpan = rowSpan;
            return this;
        }

        public Td colSpan(int colSpan) {
            this.colSpan = colSpan;
            return this;
        }

        public Td text(String text) {
            this.text = text;
            return this;
        }

        public Td fontColor(Color fontColor) {
            this.fontColor = fontColor;
            return this;
        }

        public Td fontName(String fontName) {
            this.fontName = fontName;
            return this;
        }

        public Td fontSize(double fontSize) {
            Asserts.illegalArgument(fontSize < 0.0, "");
            this.fontSize = fontSize;
            return this;
        }

        public Td shape(NodeShape shape) {
            Asserts.nullArgument(shape, "shape");
            this.shape = shape;
            return this;
        }

        public Td table(Table table) {
            this.table = table;
            return this;
        }

        public Table getTable() {
            return this.table;
        }

        public int getRowSpan() {
            return Math.max(this.rowSpan, 1);
        }

        public int getColSpan() {
            return Math.max(this.colSpan, 1);
        }

        public String getText() {
            return this.text;
        }

        public Color getFontColor() {
            return this.fontColor;
        }

        public String getFontName() {
            return this.fontName;
        }

        public double getFontSize() {
            return this.fontSize;
        }

        public NodeShape getShape() {
            return this.shape;
        }

        public Labeljust getAlign(Table table) {
            if (super.getAlign() != null) {
                return super.getAlign();
            }
            if (table != null && table.getAlign() != null) {
                return table.getAlign();
            }
            return Labeljust.CENTER;
        }

        public Labelloc getValign(Table table) {
            if (super.getValign() != null) {
                return super.getValign();
            }
            if (table != null && table.getValign() != null) {
                return table.getValign();
            }
            return Labelloc.CENTER;
        }

        public int getBorder(Table table) {
            if (this.border != null) {
                return this.border;
            }
            if (table != null) {
                return table.getCellBorder();
            }
            return 1;
        }

        public int getCellPadding(Table table) {
            if (super.getCellPadding() != null) {
                return super.getCellPadding();
            }
            if (table != null && table.getCellPadding() != null) {
                return table.getCellPadding();
            }
            return 5;
        }

        public NodeStyle getStyle(Table table) {
            if (super.getStyle() != null) {
                return super.getStyle();
            }
            if (table != null && table.getStyle() != null) {
                return table.getStyle();
            }
            return null;
        }

        public boolean isFixedSize(Table table) {
            if (super.getFixedSize() != null) {
                return super.getFixedSize();
            }
            if (table != null && table.getFixedSize() != null) {
                return table.getFixedSize();
            }
            return false;
        }
    }

    public static class Tr
    implements Serializable {
        private static final long serialVersionUID = -1203994797919820914L;
        private List<Td> tds;

        public List<Td> getTds() {
            return CollectionUtils.isEmpty(this.tds) ? Collections.emptyList() : Collections.unmodifiableList(this.tds);
        }

        public Td getTd(int tdIdx) {
            if (tdIdx < 0 || tdIdx > this.colNum() - 1) {
                throw new IndexOutOfBoundsException();
            }
            return this.tds.get(tdIdx);
        }

        public int colNum() {
            if (CollectionUtils.isEmpty(this.tds)) {
                return 0;
            }
            return this.tds.size();
        }

        private synchronized void td(Td ... tdArray) {
            if (tdArray == null || tdArray.length == 0) {
                return;
            }
            if (this.tds == null) {
                this.tds = new ArrayList<Td>();
            }
            Collections.addAll(this.tds, tdArray);
        }
    }

    public static class Table
    extends Attrs<Table>
    implements Serializable {
        private static final long serialVersionUID = 5520400546096949803L;
        private List<Tr> trs;
        private int border = 1;
        private int cellBorder = 1;
        private int cellSpacing = 2;

        public Table cellBorder(int cellBorder) {
            Asserts.illegalArgument(cellBorder < 0, "cellBorder can not be less than 0");
            this.cellBorder = cellBorder;
            return this;
        }

        public Table cellSpacing(int spacing) {
            Asserts.illegalArgument(spacing < 0, "spacing can not be less than 0");
            this.cellSpacing = spacing;
            return this;
        }

        public Table border(int border) {
            Asserts.illegalArgument(border < 0, "border can not be less than 0");
            this.border = border;
            return this.self();
        }

        public synchronized Table tr(Td ... tds) {
            Asserts.illegalArgument(tds == null || tds.length == 0, "Tds are empty");
            if (this.trs == null) {
                this.trs = new ArrayList<Tr>();
            }
            Tr tr = new Tr();
            tr.td(tds);
            this.trs.add(tr);
            return this;
        }

        public List<Tr> getTrs() {
            return CollectionUtils.isEmpty(this.trs) ? Collections.emptyList() : Collections.unmodifiableList(this.trs);
        }

        public Tr getTr(int rowIdx) {
            if (rowIdx < 0 || rowIdx > this.rowNum() - 1) {
                throw new IndexOutOfBoundsException();
            }
            return this.trs.get(rowIdx);
        }

        public int getCellBorder() {
            return this.cellBorder;
        }

        public int getCellSpacing() {
            return this.cellSpacing;
        }

        public int getBorder() {
            return this.border;
        }

        public int rowNum() {
            if (CollectionUtils.isEmpty(this.trs)) {
                return 0;
            }
            return this.trs.size();
        }

        @Override
        protected Table self() {
            return this;
        }
    }

    protected static abstract class Attrs<T> {
        private String id;
        private Labeljust align;
        private Labelloc valign;
        private Color bgColor;
        private Integer cellPadding;
        private Color color;
        private Boolean fixedSize;
        private double width = 10.0;
        private double height = 10.0;
        private String href;
        private NodeStyle style;

        protected Attrs() {
        }

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T align(Labeljust align) {
            this.align = align;
            return this.self();
        }

        public T valign(Labelloc valign) {
            this.valign = valign;
            return this.self();
        }

        public T bgColor(Color bgColor) {
            this.bgColor = bgColor;
            return this.self();
        }

        public T cellPadding(int cellPadding) {
            Asserts.illegalArgument(cellPadding < 0, "cellPadding can not be less than 0");
            this.cellPadding = cellPadding;
            return this.self();
        }

        public T color(Color color) {
            this.color = color;
            return this.self();
        }

        public T fixedSize(boolean fixedSize) {
            this.fixedSize = fixedSize;
            return this.self();
        }

        public T width(double width) {
            Asserts.illegalArgument(width <= 0.0, "width must be greater than 0");
            this.width = width;
            return this.self();
        }

        public T height(double height) {
            Asserts.illegalArgument(height <= 0.0, "height must be greater than 0");
            this.height = height;
            return this.self();
        }

        public T href(String href) {
            this.href = href;
            return this.self();
        }

        public T style(NodeStyle style) {
            this.style = style;
            return this.self();
        }

        public String getId() {
            return this.id;
        }

        public Labeljust getAlign() {
            return this.align;
        }

        public Color getBgColor() {
            return this.bgColor;
        }

        public Integer getCellPadding() {
            return this.cellPadding;
        }

        public Color getColor() {
            return this.color;
        }

        public Boolean getFixedSize() {
            return this.fixedSize;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public String getHref() {
            return this.href;
        }

        public NodeStyle getStyle() {
            return this.style;
        }

        public Labelloc getValign() {
            return this.valign;
        }
    }
}

