/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.api;

import java.io.Serializable;
import org.graphper.api.Assemble;
import org.graphper.api.FloatLabel;
import org.graphper.api.Html;
import org.graphper.api.LineAttrs;
import org.graphper.api.Node;
import org.graphper.api.attributes.ArrowShape;
import org.graphper.api.attributes.Color;
import org.graphper.api.attributes.Dir;
import org.graphper.api.attributes.LineStyle;
import org.graphper.api.attributes.Port;
import org.graphper.util.Asserts;

public class Line
implements Comparable<Line>,
Serializable {
    private static final long serialVersionUID = 7867944912063456255L;
    private static final Node EMPTY = Node.builder().build();
    private final Node head;
    private final Node tail;
    private final LineAttrs lineAttrs;

    private Line(Node head, Node tail, LineAttrs lineAttrs) {
        Asserts.nullArgument(head, "head");
        Asserts.nullArgument(tail, "tail");
        Asserts.nullArgument(lineAttrs, "lineAttrs");
        this.head = head;
        this.tail = tail;
        this.lineAttrs = lineAttrs;
    }

    public Node head() {
        return this.head;
    }

    public Node tail() {
        return this.tail;
    }

    public Node other(Node node) {
        if (node == this.head) {
            return this.tail;
        }
        if (node == this.tail) {
            return this.head;
        }
        return null;
    }

    public double weight() {
        return this.lineAttrs.weight != null ? this.lineAttrs.weight : 1.0;
    }

    public LineAttrs lineAttrs() {
        return this.lineAttrs;
    }

    @Override
    public int compareTo(Line o) {
        if (o == this) {
            return 0;
        }
        if (o == null) {
            return 1;
        }
        int c = this.tail.compareTo(o.tail);
        if (c != 0) {
            return c;
        }
        c = this.head.compareTo(o.head);
        if (c != 0) {
            return c;
        }
        c = Integer.compare(this.lineAttrs.hashCode(), o.lineAttrs.hashCode());
        if (c != 0) {
            return c;
        }
        return this.hashCode() - o.hashCode();
    }

    public static LineBuilder builder(Node tail, Node head) {
        return new LineBuilder(tail, head);
    }

    public static LineBuilder tempLine() {
        return new LineBuilder(EMPTY, EMPTY);
    }

    public static class LineBuilder {
        protected Node from;
        protected Node to;
        protected LineAttrs lineAttrs;

        private LineBuilder(Node from, Node to) {
            if (from == null || to == null) {
                throw new NullPointerException("node can not be null");
            }
            this.from = from;
            this.to = to;
            this.lineAttrs = new LineAttrs();
        }

        public LineBuilder id(String id) {
            Asserts.nullArgument(id, "id");
            this.lineAttrs.id = id;
            return this;
        }

        public LineBuilder label(String label) {
            this.lineAttrs.label = label;
            return this;
        }

        public LineBuilder controlPoints(boolean controlPoints) {
            this.lineAttrs.controlPoints = controlPoints;
            return this;
        }

        public LineBuilder showboxes(boolean showboxes) {
            this.lineAttrs.showboxes = showboxes;
            return this;
        }

        public LineBuilder radian(double radian) {
            Asserts.illegalArgument(radian < 0.0, "radian (" + radian + ") can not less than 0");
            this.lineAttrs.radian = radian;
            return this;
        }

        public LineBuilder color(Color color) {
            this.lineAttrs.color = color;
            return this;
        }

        public LineBuilder weight(double weight) {
            this.lineAttrs.weight = weight;
            return this;
        }

        public LineBuilder fontColor(Color fontColor) {
            this.lineAttrs.fontColor = fontColor;
            return this;
        }

        public LineBuilder fontSize(double fontSize) {
            Asserts.illegalArgument(fontSize < 0.0, "fontSize (" + fontSize + ") can not less than 0");
            this.lineAttrs.fontSize = fontSize;
            return this;
        }

        public LineBuilder fontName(String fontName) {
            this.lineAttrs.fontName = fontName;
            return this;
        }

        public LineBuilder headclip(boolean headclip) {
            this.lineAttrs.headclip = headclip;
            return this;
        }

        public LineBuilder tailclip(boolean tailclip) {
            this.lineAttrs.tailclip = tailclip;
            return this;
        }

        public LineBuilder minlen(int minlen) {
            Asserts.illegalArgument(minlen < 0, "minlen (" + minlen + ") can not less than 0");
            this.lineAttrs.minlen = minlen;
            return this;
        }

        public LineBuilder style(LineStyle lineStyle) {
            this.lineAttrs.style = lineStyle;
            return this;
        }

        public LineBuilder arrowHead(ArrowShape arrowHead) {
            this.lineAttrs.arrowHead = arrowHead;
            return this;
        }

        public LineBuilder arrowTail(ArrowShape arrowTail) {
            this.lineAttrs.arrowTail = arrowTail;
            return this;
        }

        public LineBuilder arrowSize(double arrowSize) {
            Asserts.illegalArgument(arrowSize < 0.0, "arrowSize (" + arrowSize + ") can not less than 0");
            this.lineAttrs.arrowSize = arrowSize * 72.0 / 10.0;
            return this;
        }

        public LineBuilder dir(Dir dir) {
            this.lineAttrs.dir = dir;
            return this;
        }

        public LineBuilder lhead(String lhead) {
            this.lineAttrs.lhead = lhead;
            return this;
        }

        public LineBuilder ltail(String ltail) {
            this.lineAttrs.ltail = ltail;
            return this;
        }

        public LineBuilder floatLabels(FloatLabel ... floatLabels) {
            Asserts.illegalArgument(floatLabels == null || floatLabels.length == 0, "floatLabels is empty");
            for (FloatLabel floatLabel : floatLabels) {
                Asserts.illegalArgument(floatLabel == null, "Float label array contains null item");
            }
            this.lineAttrs.floatLabels = floatLabels;
            return this;
        }

        public LineBuilder tailPort(Port tailPort) {
            this.lineAttrs.tailPort = tailPort;
            return this;
        }

        public LineBuilder headPort(Port headPort) {
            this.lineAttrs.headPort = headPort;
            return this;
        }

        public LineBuilder tailCell(String tailCell) {
            this.lineAttrs.tailCell = tailCell;
            return this;
        }

        public LineBuilder headCell(String headCell) {
            this.lineAttrs.headCell = headCell;
            return this;
        }

        public LineBuilder href(String href) {
            this.lineAttrs.href = href;
            return this;
        }

        public LineBuilder penWidth(double penWidth) {
            Asserts.illegalArgument(penWidth <= 0.0, "penWidth must be greater than 0");
            this.lineAttrs.penWidth = penWidth;
            return this;
        }

        public LineBuilder table(Html.Table table) {
            this.lineAttrs.table = table;
            return this;
        }

        public LineBuilder assemble(Assemble assemble) {
            this.lineAttrs.assemble = assemble;
            return this;
        }

        public Line build() {
            return new Line(this.to, this.from, this.lineAttrs);
        }
    }
}

