/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.api;

import java.io.Serializable;
import java.util.Objects;
import org.graphper.api.Assemble;
import org.graphper.api.Html;
import org.graphper.api.NodeAttrs;
import org.graphper.api.attributes.Color;
import org.graphper.api.attributes.Labeljust;
import org.graphper.api.attributes.Labelloc;
import org.graphper.api.attributes.NodeShape;
import org.graphper.api.attributes.NodeStyle;
import org.graphper.def.FlatPoint;
import org.graphper.def.VertexIndex;
import org.graphper.util.Asserts;

public class Node
extends VertexIndex
implements Comparable<Node>,
Serializable {
    private static final long serialVersionUID = 4616284202432237469L;
    private final NodeAttrs nodeAttrs;

    private Node(NodeAttrs nodeAttrs) {
        Objects.requireNonNull(nodeAttrs);
        this.nodeAttrs = nodeAttrs;
    }

    public NodeAttrs nodeAttrs() {
        return this.nodeAttrs;
    }

    public static NodeBuilder builder() {
        return new NodeBuilder();
    }

    @Override
    public int compareTo(Node o) {
        if (o == this) {
            return 0;
        }
        if (o == null || o.nodeAttrs.label == null) {
            return 1;
        }
        if (this.nodeAttrs.label == null) {
            return -1;
        }
        int c = this.nodeAttrs.label.compareTo(o.nodeAttrs.label);
        if (c == 0 && this.nodeAttrs.id != null) {
            c = this.nodeAttrs.id.compareTo(o.nodeAttrs.id);
        }
        return c != 0 ? c : this.hashCode() - o.hashCode();
    }

    public static final class NodeBuilder {
        private final NodeAttrs nodeAttrs = new NodeAttrs();

        private NodeBuilder() {
        }

        public NodeBuilder id(String id) {
            this.nodeAttrs.id = id;
            return this;
        }

        public NodeBuilder label(String label) {
            this.nodeAttrs.label = label;
            return this;
        }

        public NodeBuilder height(double height) {
            Asserts.illegalArgument(height < 0.0, "Height (" + height + ") can not less than 0");
            this.nodeAttrs.height = height * 72.0;
            return this;
        }

        public NodeBuilder width(double width) {
            Asserts.illegalArgument(width < 0.0, "width (" + width + ") must be > 0");
            this.nodeAttrs.width = width * 72.0;
            return this;
        }

        public NodeBuilder shape(NodeShape shape) {
            this.nodeAttrs.shape = shape;
            return this;
        }

        public NodeBuilder color(Color color) {
            this.nodeAttrs.color = color;
            return this;
        }

        public NodeBuilder fillColor(Color fillColor) {
            this.nodeAttrs.fillColor = fillColor;
            return this;
        }

        public NodeBuilder fontColor(Color fontColor) {
            this.nodeAttrs.fontColor = fontColor;
            return this;
        }

        public NodeBuilder fontName(String fontName) {
            this.nodeAttrs.fontName = fontName;
            return this;
        }

        public NodeBuilder labeljust(Labeljust labeljust) {
            this.nodeAttrs.labeljust = labeljust;
            return this;
        }

        public NodeBuilder labelloc(Labelloc labelloc) {
            this.nodeAttrs.labelloc = labelloc;
            return this;
        }

        public NodeBuilder margin(double margin) {
            return this.margin(margin, margin);
        }

        public NodeBuilder margin(double horMargin, double verMargin) {
            Asserts.illegalArgument(horMargin < 0.0, "Horizontal margin (" + horMargin + ") can not less than 0");
            Asserts.illegalArgument(verMargin < 0.0, "Vertical margin (" + verMargin + ") can not less than 0");
            this.nodeAttrs.margin = new FlatPoint.UnmodifyFlatPoint(verMargin * 72.0, horMargin * 72.0);
            return this;
        }

        public NodeBuilder fixedSize(boolean fixedSize) {
            this.nodeAttrs.fixedSize = fixedSize;
            return this;
        }

        public NodeBuilder fontSize(double fontSize) {
            Asserts.illegalArgument(fontSize < 0.0, "fontSize (" + fontSize + ") can not less than 0");
            this.nodeAttrs.fontSize = fontSize;
            return this;
        }

        public NodeBuilder style(NodeStyle nodeStyle) {
            this.nodeAttrs.style = nodeStyle;
            return this;
        }

        public NodeBuilder sides(int sides) {
            Asserts.illegalArgument(sides < 4, "side can not be lower than 4");
            Asserts.illegalArgument(sides > 20, "side can not be large than 20");
            this.nodeAttrs.sides = sides;
            return this;
        }

        public NodeBuilder href(String href) {
            this.nodeAttrs.href = href;
            return this;
        }

        public NodeBuilder image(String image) {
            this.nodeAttrs.image = image;
            return this;
        }

        public NodeBuilder imageSize(double height, double width) {
            Asserts.illegalArgument(height <= 0.0, "Image height can not less than 0");
            Asserts.illegalArgument(width <= 0.0, "Image width can not less than 0");
            this.nodeAttrs.imageSize = new FlatPoint.UnmodifyFlatPoint(height * 72.0, width * 72.0);
            return this;
        }

        public NodeBuilder penWidth(double penWidth) {
            Asserts.illegalArgument(penWidth < 0.0, "penWidth can not be less than 0");
            this.nodeAttrs.penWidth = penWidth;
            return this;
        }

        public NodeBuilder table(Html.Table table) {
            Asserts.nullArgument(table, "table");
            this.nodeAttrs.table = table;
            return this;
        }

        public NodeBuilder assemble(Assemble assemble) {
            this.nodeAttrs.assemble = assemble;
            return this;
        }

        public Node build() {
            return new Node(this.nodeAttrs.clone());
        }
    }
}

