/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.api.attributes;

import java.io.Serializable;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache_gs.commons.lang3.StringUtils;
import org.graphper.def.ColorFormatException;

public abstract class Color
implements Serializable {
    private static final long serialVersionUID = 2828231898265525591L;
    public static final Color BLACK = Color.ofRGB("#000000");
    public static final Color WHITE = Color.ofRGB("#ffffff");
    public static final Color RED = Color.ofRGB("#ff0000");
    public static final Color ORANGE = Color.ofRGB("#ffa500");
    public static final Color YELLOW = Color.ofRGB("#ffff00");
    public static final Color GREEN = Color.ofRGB("#00ff00");
    public static final Color BLUE = Color.ofRGB("#0000ff");
    public static final Color INDIGO = Color.ofRGB("#4b0082");
    public static final Color PURPLE = Color.ofRGB("#800080");
    public static final Color GOLD = Color.ofRGB("#ffd700");
    public static final Color GREY = Color.ofRGB("#c0c0c0");
    public static final Color PINK = Color.ofRGB("#ffc0cb");

    public abstract String value();

    public static Color ofRGB(String rgb) {
        return new RgbColor(rgb);
    }

    static class RgbColor
    extends AbstractColor {
        private static final long serialVersionUID = -1294848178007135771L;
        private static final Pattern pattern = Pattern.compile("^#([0-9a-fA-F]{6}|[0-9a-fA-F]{3})$");

        RgbColor(String color) {
            super(color);
        }

        @Override
        protected String formatNormal(String color) throws ColorFormatException {
            RgbColor.emptyColorValid(color);
            String c = color.trim();
            Matcher matcher = pattern.matcher(color);
            if (!matcher.find()) {
                throw new ColorFormatException("Illegal RGB color param [" + color + "]");
            }
            if (c.length() == 4) {
                c = c + "000";
            }
            return c;
        }

        public String toString() {
            return "RgbColor{colorVal='" + this.colorVal + '\'' + '}';
        }
    }

    static abstract class AbstractColor
    extends Color
    implements Serializable {
        private static final long serialVersionUID = -7757877504759666027L;
        protected final String colorVal;

        protected AbstractColor(String color) {
            this.colorVal = this.formatNormal(color);
        }

        protected static void emptyColorValid(String color) {
            if (StringUtils.isEmpty(color)) {
                throw new ColorFormatException("color can not be empty");
            }
        }

        @Override
        public String value() {
            return this.colorVal;
        }

        protected abstract String formatNormal(String var1) throws ColorFormatException;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AbstractColor that = (AbstractColor)o;
            return Objects.equals(this.colorVal, that.colorVal);
        }

        public int hashCode() {
            return Objects.hash(this.colorVal);
        }
    }
}

