/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.api.attributes;

import org.graphper.api.NodeAttrs;
import org.graphper.api.attributes.Color;
import org.graphper.api.attributes.NodeShape;
import org.graphper.api.ext.Box;
import org.graphper.api.ext.CirclePropCalc;
import org.graphper.api.ext.CylinderPropCalc;
import org.graphper.api.ext.DiamondPropCalc;
import org.graphper.api.ext.EllipsePropCalc;
import org.graphper.api.ext.NotePropCalc;
import org.graphper.api.ext.ParallelogramPropCalc;
import org.graphper.api.ext.PlainPropCalc;
import org.graphper.api.ext.PointPropCalc;
import org.graphper.api.ext.RecordPropCalc;
import org.graphper.api.ext.RectanglePropCalc;
import org.graphper.api.ext.RegularPolylinePropCalc;
import org.graphper.api.ext.ShapeCenterCalc;
import org.graphper.api.ext.ShapePropCalc;
import org.graphper.api.ext.StarPropCalc;
import org.graphper.api.ext.SymmetryShapeCenterCalc;
import org.graphper.api.ext.TrapeziumPropCalc;
import org.graphper.api.ext.TrianglePropCalc;
import org.graphper.def.FlatPoint;
import org.graphper.util.Asserts;

public enum NodeShapeEnum implements NodeShape
{
    NOTE("note", new NotePropCalc()),
    PLAIN("plain", 0.1, 0.1, new PlainPropCalc()),
    PLAIN_TEXT("plaintext", new EllipsePropCalc()),
    UNDERLINE("underline", new RectanglePropCalc()),
    ELLIPSE("ellipse", new EllipsePropCalc()),
    CIRCLE("circle", 0.75, 0.75, new CirclePropCalc()),
    RECT("rect", new RectanglePropCalc()),
    POINT("point", 0.1, 0.1, new PointPropCalc()),
    TRIANGLE("triangle", new TrianglePropCalc()),
    DIAMOND("diamond", new DiamondPropCalc()),
    TRAPEZIUM("trapezium", new TrapeziumPropCalc()),
    PARALLELOGRAM("parallelogram", new ParallelogramPropCalc()),
    STAR("star", 0.75, 0.75, new StarPropCalc()),
    CYLINDER("cylinder", new CylinderPropCalc()),
    REGULAR_POLYLINE("regular_polyline", 0.75, 0.75, new RegularPolylinePropCalc()),
    RECORD("record", 0.75, 1.0, new RecordPropCalc(false)),
    M_RECORD("Mrecord", 0.75, 1.0, new RecordPropCalc(true));

    private final String name;
    private double defaultHeight = 0.5;
    private double defaultWidth = 0.75;
    private final ShapeCenterCalc shapeCenterCalc;
    private final ShapePropCalc shapePropCalc;

    private NodeShapeEnum(String name, ShapePropCalc shapePropCalc) {
        this.name = name;
        this.shapeCenterCalc = SymmetryShapeCenterCalc.SSPC;
        this.shapePropCalc = shapePropCalc;
    }

    private NodeShapeEnum(String name, double defaultHeight, double defaultWidth, ShapePropCalc shapePropCalc) {
        this(name, defaultHeight, defaultWidth, SymmetryShapeCenterCalc.SSPC, shapePropCalc);
    }

    private NodeShapeEnum(String name, double defaultHeight, double defaultWidth, ShapeCenterCalc shapeCenterCalc, ShapePropCalc shapePropCalc) {
        this.name = name;
        this.defaultHeight = defaultHeight;
        this.defaultWidth = defaultWidth;
        this.shapeCenterCalc = shapeCenterCalc;
        this.shapePropCalc = shapePropCalc;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double leftWidth(Double width) {
        return this.shapeCenterCalc.leftWidth(width);
    }

    @Override
    public double rightWidth(Double width) {
        return this.shapeCenterCalc.rightWidth(width);
    }

    @Override
    public double topHeight(Double height) {
        return this.shapeCenterCalc.topHeight(height);
    }

    @Override
    public double bottomHeight(Double height) {
        return this.shapeCenterCalc.bottomHeight(height);
    }

    @Override
    public FlatPoint minContainerSize(double innerHeight, double innerWidth) {
        if (innerHeight == 0.0 || innerWidth == 0.0) {
            return new FlatPoint(0.0, 0.0);
        }
        return this.shapePropCalc.minContainerSize(innerHeight, innerWidth);
    }

    @Override
    public boolean in(Box box, FlatPoint point) {
        Asserts.nullArgument(box, "shapePosition");
        Asserts.nullArgument(point, "point");
        return this.shapePropCalc.in(box, point);
    }

    @Override
    public void ratio(FlatPoint boxSize) {
        Asserts.nullArgument(boxSize, "boxSize");
        this.shapePropCalc.ratio(boxSize);
    }

    @Override
    public FlatPoint labelCenter(FlatPoint labelSize, Box box) {
        Asserts.nullArgument(box, "box");
        Asserts.nullArgument(labelSize, "labelSize");
        return this.shapePropCalc.labelCenter(labelSize, box);
    }

    @Override
    public boolean needMargin() {
        return this.shapePropCalc.needMargin();
    }

    @Override
    public boolean ignoreLabel() {
        return this.shapePropCalc.ignoreLabel();
    }

    @Override
    public Color defaultFillColor() {
        return this.shapePropCalc.defaultFillColor();
    }

    @Override
    public NodeShape post(NodeAttrs nodeAttrs) {
        return this.shapePropCalc.post(nodeAttrs);
    }

    @Override
    public ShapePropCalc getShapePropCalc() {
        return this.shapePropCalc;
    }

    @Override
    public double getDefaultHeight() {
        return this.defaultHeight * 72.0;
    }

    @Override
    public double getDefaultWidth() {
        return this.defaultWidth * 72.0;
    }
}

