/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.api.attributes;

import java.util.Objects;
import org.graphper.api.ext.Box;
import org.graphper.api.ext.PortPosition;
import org.graphper.api.ext.RatioPortPosition;
import org.graphper.util.Asserts;

public enum Port implements PortPosition
{
    CENTER(-1, "c", new RatioPortPosition(0.0, 0.0)),
    WEST(0, "w", new RatioPortPosition(-0.5, 0.0)),
    NORTH_WEST(1, "nw", new RatioPortPosition(-0.5, -0.5)),
    NORTH(2, "n", new RatioPortPosition(0.0, -0.5)),
    NORTH_EAST(3, "ne", new RatioPortPosition(0.5, -0.5)),
    EAST(4, "e", new RatioPortPosition(0.5, 0.0)),
    SOUTH_EAST(5, "se", new RatioPortPosition(0.5, 0.5)),
    SOUTH(6, "s", new RatioPortPosition(0.0, 0.5)),
    SOUTH_WEST(7, "sw", new RatioPortPosition(-0.5, 0.5));

    private final RatioPortPosition portPosition;
    private final int no;
    private final String code;

    private Port(int no, String code, RatioPortPosition portPosition) {
        this.no = no;
        this.code = code;
        this.portPosition = portPosition;
    }

    @Override
    public double horOffset(Box box) {
        return this.portPosition.horOffset(box);
    }

    @Override
    public double verOffset(Box box) {
        return this.portPosition.verOffset(box);
    }

    public int getNo() {
        return this.no;
    }

    public boolean isAxis() {
        return this == WEST || this == NORTH || this == EAST || this == SOUTH;
    }

    public Port pre() {
        if (this.no == 0) {
            return Port.valueOf(Port.maxNo() - 1);
        }
        return Port.valueOf(this.no - 1);
    }

    public Port next() {
        if (this.no == Port.maxNo() - 1) {
            return Port.valueOf(0);
        }
        return Port.valueOf(this.no + 1);
    }

    public static int maxNo() {
        return Port.values().length - 1;
    }

    public static Port valueOf(int no) {
        Asserts.illegalArgument(no < 0 || no >= Port.values().length, "Port no must between 0 and " + (Port.values().length - 1));
        return Port.values()[no + 1];
    }

    public double horOffsetRatio() {
        return this.portPosition.getxRatio();
    }

    public double verOffsetRatio() {
        return this.portPosition.getyRatio();
    }

    public static Port valueOfCode(String code) {
        for (Port port : Port.values()) {
            if (!Objects.equals(port.code, code)) continue;
            return port;
        }
        return null;
    }
}

