/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.api.ext;

import org.graphper.def.FlatPoint;
import org.graphper.util.Asserts;

public interface Box {
    public static final String HORIZONTAL_ERROR = "Box's right wall must be greater than left wall";
    public static final String VERTICAL_ERROR = "Box's down wall must be greater than up wall";

    public double getLeftBorder();

    public double getRightBorder();

    public double getUpBorder();

    public double getDownBorder();

    default public double getHeight() {
        return Math.abs(this.getUpBorder() - this.getDownBorder());
    }

    default public double getWidth() {
        return Math.abs(this.getLeftBorder() - this.getRightBorder());
    }

    default public double getX() {
        return (this.getLeftBorder() + this.getRightBorder()) / 2.0;
    }

    default public double getY() {
        return (this.getUpBorder() + this.getDownBorder()) / 2.0;
    }

    default public FlatPoint getLeftUp() {
        return new FlatPoint(this.getLeftBorder(), this.getUpBorder());
    }

    default public FlatPoint getRightDown() {
        return new FlatPoint(this.getRightBorder(), this.getDownBorder());
    }

    default public void check() {
        Asserts.illegalArgument(this.getLeftBorder() > this.getRightBorder(), HORIZONTAL_ERROR);
        Asserts.illegalArgument(this.getUpBorder() > this.getDownBorder(), VERTICAL_ERROR);
    }

    default public boolean in(double x, double y) {
        return x >= this.getLeftBorder() - 0.1 && x <= this.getRightBorder() + 0.1 && y >= this.getUpBorder() - 0.1 && y <= this.getDownBorder() + 0.1;
    }
}

