/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.api.ext;

import java.io.Serializable;
import org.graphper.api.ext.Box;
import org.graphper.api.ext.ShapePropCalc;
import org.graphper.def.FlatPoint;

public class CirclePropCalc
implements ShapePropCalc,
Serializable {
    private static final long serialVersionUID = 4004804900027011314L;

    @Override
    public FlatPoint minContainerSize(double innerHeight, double innerWidth) {
        double diameter = Math.sqrt(Math.pow(innerHeight, 2.0) + Math.pow(innerWidth, 2.0));
        return new FlatPoint(diameter, diameter);
    }

    @Override
    public boolean in(Box box, FlatPoint flatPoint) {
        double r = Math.pow(flatPoint.getX() - box.getX(), 2.0) + Math.pow(flatPoint.getY() - box.getY(), 2.0);
        return Math.sqrt(r) <= box.getWidth() / 2.0;
    }

    @Override
    public void ratio(FlatPoint boxSize) {
        this.squareRatio(boxSize);
    }
}

