/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.api.ext;

import java.util.Objects;
import org.graphper.api.ext.Box;
import org.graphper.util.Asserts;

public class DefaultBox
implements Box {
    protected double leftBorder;
    protected double rightBorder;
    protected double upBorder;
    protected double downBorder;

    public DefaultBox() {
    }

    public DefaultBox(double leftBorder, double rightBorder, double upBorder, double downBorder) {
        Asserts.illegalArgument(leftBorder > rightBorder, "Box's right wall must be greater than left wall");
        Asserts.illegalArgument(upBorder > downBorder, "Box's down wall must be greater than up wall");
        this.leftBorder = leftBorder;
        this.rightBorder = rightBorder;
        this.upBorder = upBorder;
        this.downBorder = downBorder;
    }

    @Override
    public double getLeftBorder() {
        return this.leftBorder;
    }

    @Override
    public double getRightBorder() {
        return this.rightBorder;
    }

    @Override
    public double getUpBorder() {
        return this.upBorder;
    }

    @Override
    public double getDownBorder() {
        return this.downBorder;
    }

    public void setLeftBorder(double leftBorder) {
        this.leftBorder = leftBorder;
    }

    public void setRightBorder(double rightBorder) {
        this.rightBorder = rightBorder;
    }

    public void setUpBorder(double upBorder) {
        this.upBorder = upBorder;
    }

    public void setDownBorder(double downBorder) {
        this.downBorder = downBorder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultBox routerBox = (DefaultBox)o;
        return Double.compare(routerBox.leftBorder, this.leftBorder) == 0 && Double.compare(routerBox.rightBorder, this.rightBorder) == 0 && Double.compare(routerBox.upBorder, this.upBorder) == 0 && Double.compare(routerBox.downBorder, this.downBorder) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.leftBorder, this.rightBorder, this.upBorder, this.downBorder);
    }

    public String toString() {
        return "DefaultBox{leftBorder=" + this.leftBorder + ", rightBorder=" + this.rightBorder + ", upBorder=" + this.upBorder + ", downBorder=" + this.downBorder + '}';
    }
}

