/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.api.ext;

import java.io.Serializable;
import org.graphper.api.attributes.NodeShapeEnum;
import org.graphper.api.ext.Box;
import org.graphper.api.ext.ShapePropCalc;
import org.graphper.def.FlatPoint;

public class EllipsePropCalc
implements ShapePropCalc,
Serializable {
    private static final long serialVersionUID = 5285076865672929036L;

    @Override
    public FlatPoint minContainerSize(double innerHeight, double innerWidth) {
        double boxHalfHeight;
        double boxHalfWidth;
        double lheight;
        boolean boxNotInEllipse;
        double rw;
        double th = NodeShapeEnum.ELLIPSE.topHeight(innerHeight);
        double bh = NodeShapeEnum.ELLIPSE.bottomHeight(innerHeight);
        double lw = NodeShapeEnum.ELLIPSE.leftWidth(innerWidth);
        double lwidth = Math.max(lw, rw = NodeShapeEnum.ELLIPSE.rightWidth(innerWidth));
        boolean bl = boxNotInEllipse = this.ellipseFormula(lwidth, lheight = Math.max(th, bh), boxHalfWidth = innerWidth / 2.0, boxHalfHeight = innerHeight / 2.0) > 1.0;
        if (boxNotInEllipse) {
            double scale = lwidth / lheight;
            lwidth = Math.sqrt(Math.pow(boxHalfWidth, 2.0) + Math.pow(boxHalfHeight, 2.0) * Math.pow(scale, 2.0));
            lheight = lwidth / scale;
        }
        return new FlatPoint(lheight * 2.0, lwidth * 2.0);
    }

    @Override
    public boolean in(Box box, FlatPoint point) {
        double h;
        double w = NodeShapeEnum.ELLIPSE.leftWidth(box.getWidth());
        return this.ellipseFormula(w, h = NodeShapeEnum.ELLIPSE.topHeight(box.getHeight()), point.getX() - box.getX(), point.getY() - box.getY()) <= 1.0;
    }

    private double ellipseFormula(double a, double b, double x, double y) {
        return Math.pow(x, 2.0) / Math.pow(a, 2.0) + Math.pow(y, 2.0) / Math.pow(b, 2.0);
    }
}

