/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.api.ext;

import java.io.Serializable;
import org.graphper.def.FlatPoint;
import org.graphper.util.Asserts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LabelPositionCalc
implements Serializable {
    private static final long serialVersionUID = -7315061356667594850L;
    private static final Logger log = LoggerFactory.getLogger(LabelPositionCalc.class);

    public double centerPos(FlatPoint upperLeft, FlatPoint lowerRight, FlatPoint labelSize) {
        Asserts.nullArgument(upperLeft, "upperLeft");
        Asserts.nullArgument(lowerRight, "lowerRight");
        Asserts.nullArgument(labelSize, "labelSize");
        if (log.isWarnEnabled()) {
            if (labelSize.getWidth() > Math.abs(lowerRight.getX() - upperLeft.getX()) || labelSize.getHeight() > Math.abs(lowerRight.getY() - upperLeft.getY())) {
                log.warn("The label routerBox size is larger than the outer container");
            }
            if (labelSize.getWidth() < 0.0 || labelSize.getHeight() < 0.0) {
                log.warn("label routerBox size is less than 0");
            }
        }
        return this.centerPos0(upperLeft, lowerRight, labelSize);
    }

    protected abstract double centerPos0(FlatPoint var1, FlatPoint var2, FlatPoint var3);

    public static class VerCenterLabelPositionCalc
    extends LabelPositionCalc {
        private static final long serialVersionUID = -8949864737194759650L;

        @Override
        protected double centerPos0(FlatPoint upperLeft, FlatPoint lowerRight, FlatPoint labelSize) {
            return (upperLeft.getY() + lowerRight.getY()) / 2.0;
        }
    }

    public static class HorCenterLabelPositionCalc
    extends LabelPositionCalc {
        private static final long serialVersionUID = -8949864737194759650L;

        @Override
        protected double centerPos0(FlatPoint upperLeft, FlatPoint lowerRight, FlatPoint labelSize) {
            return (upperLeft.getX() + lowerRight.getX()) / 2.0;
        }
    }

    public static class BottomLabelPositionCalc
    extends LabelPositionCalc {
        private static final long serialVersionUID = -8949864737194759650L;

        @Override
        protected double centerPos0(FlatPoint upperLeft, FlatPoint lowerRight, FlatPoint labelSize) {
            return lowerRight.getY() - labelSize.getHeight() / 2.0;
        }
    }

    public static class TopLabelPositionCalc
    extends LabelPositionCalc {
        private static final long serialVersionUID = -8949864737194759650L;

        @Override
        protected double centerPos0(FlatPoint upperLeft, FlatPoint lowerRight, FlatPoint labelSize) {
            return upperLeft.getY() + labelSize.getHeight() / 2.0;
        }
    }

    public static class RightLabelPositionCalc
    extends LabelPositionCalc {
        private static final long serialVersionUID = -8949864737194759650L;

        @Override
        protected double centerPos0(FlatPoint upperLeft, FlatPoint lowerRight, FlatPoint labelSize) {
            return lowerRight.getX() - labelSize.getWidth() / 2.0;
        }
    }

    public static class LeftLabelPositionCalc
    extends LabelPositionCalc {
        private static final long serialVersionUID = -8949864737194759650L;

        @Override
        protected double centerPos0(FlatPoint upperLeft, FlatPoint lowerRight, FlatPoint labelSize) {
            return upperLeft.getX() + labelSize.getWidth() / 2.0;
        }
    }
}

