/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.api.ext;

import java.io.Serializable;
import org.graphper.api.attributes.NodeShapeEnum;
import org.graphper.api.ext.Box;
import org.graphper.api.ext.ShapePropCalc;
import org.graphper.def.FlatPoint;
import org.graphper.def.Vectors;

public class NotePropCalc
implements ShapePropCalc,
Serializable {
    private static final long serialVersionUID = -2681885778176559296L;
    public static final int RIGHT_UP_LEN = 6;
    private static final int HALF_RIGHT_UP_LEN = 3;

    @Override
    public FlatPoint minContainerSize(double innerHeight, double innerWidth) {
        return new FlatPoint(innerHeight, innerWidth);
    }

    @Override
    public boolean in(Box box, FlatPoint point) {
        if (box.getHeight() <= 6.0 || box.getWidth() <= 6.0) {
            return NodeShapeEnum.RECT.in(box, point);
        }
        if (this.inLeftBox(box, point) || this.inRightBox(box, point)) {
            return true;
        }
        return this.inRightUpCorner(box, point);
    }

    private boolean inLeftBox(Box box, FlatPoint point) {
        double leftBoxWidth = box.getWidth() - 6.0;
        return Math.abs(box.getX() - 3.0 - point.getX()) <= leftBoxWidth / 2.0 && Math.abs(box.getY() - point.getY()) <= box.getHeight() / 2.0;
    }

    private boolean inRightBox(Box box, FlatPoint point) {
        double rightBoxHeight = box.getHeight() - 6.0;
        return Math.abs(box.getRightBorder() - 3.0 - point.getX()) <= 3.0 && Math.abs(box.getY() + 3.0 - point.getY()) <= rightBoxHeight / 2.0;
    }

    private boolean inRightUpCorner(Box box, FlatPoint point) {
        double rightAngleY;
        double rightAngleX = box.getRightBorder() - 6.0;
        return Vectors.inAngle(rightAngleX, rightAngleY = box.getUpBorder() + 6.0, rightAngleX, box.getUpBorder(), box.getRightBorder(), rightAngleY, point.getX(), point.getY()) && Vectors.inAngle(box.getRightBorder(), rightAngleY, box.getRightBorder(), rightAngleY, rightAngleX, box.getUpBorder(), point.getX(), point.getY());
    }
}

