/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.api.ext;

import java.io.Serializable;
import org.graphper.api.ext.Box;
import org.graphper.api.ext.ShapePropCalc;
import org.graphper.def.FlatPoint;
import org.graphper.def.Vectors;

public class ParallelogramPropCalc
implements ShapePropCalc,
Serializable {
    private static final long serialVersionUID = -6518952765537706926L;

    @Override
    public FlatPoint minContainerSize(double innerHeight, double innerWidth) {
        return new FlatPoint(innerHeight, 5.0 * innerWidth / 3.0);
    }

    @Override
    public boolean in(Box box, FlatPoint point) {
        double rightDownX;
        double leftTopX;
        double left = box.getLeftBorder();
        double right = box.getRightBorder();
        double up = box.getUpBorder();
        double down = box.getDownBorder();
        return Vectors.inAngle(left, down, leftTopX = box.getLeftBorder() + box.getWidth() / 5.0, up, rightDownX = box.getRightBorder() - box.getWidth() / 5.0, down, point.getX(), point.getY()) && Vectors.inAngle(right, up, leftTopX, up, rightDownX, down, point.getX(), point.getY());
    }
}

