/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.api.ext;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import org.graphper.api.NodeAttrs;
import org.graphper.api.attributes.NodeShape;
import org.graphper.api.ext.Box;
import org.graphper.api.ext.ShapePropCalc;
import org.graphper.def.FlatPoint;
import org.graphper.def.UnfeasibleException;
import org.graphper.def.Vectors;
import org.graphper.util.Asserts;
import org.graphper.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegularPolylinePropCalc
implements ShapePropCalc,
Serializable {
    private static final long serialVersionUID = 8672914749052162330L;
    private static final Logger log = LoggerFactory.getLogger(RegularPolylinePropCalc.class);
    private int side = 4;
    private List<FlatPoint> flatPoints;

    public RegularPolylinePropCalc() {
    }

    private RegularPolylinePropCalc(int side) {
        Asserts.illegalArgument(side <= 0, "side can not be lower than 0");
        this.side = side;
    }

    @Override
    public FlatPoint minContainerSize(double innerHeight, double innerWidth) {
        if (innerHeight == 0.0 || innerWidth == 0.0) {
            return new FlatPoint(0.0, 0.0);
        }
        double diameter = Math.sqrt(Math.pow(innerHeight, 2.0) + Math.pow(innerWidth, 2.0));
        diameter += this.expansion(diameter / 2.0, innerHeight, innerWidth);
        return new FlatPoint(diameter, diameter);
    }

    @Override
    public boolean in(Box box, FlatPoint point) {
        Asserts.nullArgument(box, "box");
        Asserts.nullArgument(point, "point");
        this.initPoints(box);
        for (int i = 0; i < this.flatPoints.size(); ++i) {
            FlatPoint pre = this.adjPoint(i, true);
            FlatPoint next = this.adjPoint(i, false);
            FlatPoint current = this.flatPoints.get(i);
            if (Vectors.inAngle(current, pre, next, point)) continue;
            return false;
        }
        return true;
    }

    @Override
    public NodeShape post(NodeAttrs nodeAttrs) {
        Asserts.nullArgument(nodeAttrs, "nodeAttrs");
        NodeShape nodeShape = nodeAttrs.getNodeShape();
        Integer nodeSide = nodeAttrs.getSides();
        if (nodeSide == null) {
            return nodeShape;
        }
        RegularPolylinePropCalc propCalc = new RegularPolylinePropCalc(nodeSide);
        return (NodeShape)Proxy.newProxyInstance(NodeShape.class.getClassLoader(), new Class[]{NodeShape.class}, (InvocationHandler)new RegularProxyInvoker(nodeShape, propCalc));
    }

    public void initPoints(Box box) {
        Asserts.nullArgument(box, "box");
        if (this.flatPoints == null) {
            this.flatPoints = new ArrayList<FlatPoint>(this.side);
        }
        if (CollectionUtils.isNotEmpty(this.flatPoints)) {
            return;
        }
        this.flatPoints = this.calcPoints(box);
    }

    public List<FlatPoint> calcPoints(Box box) {
        Asserts.nullArgument(box, "box");
        ArrayList<FlatPoint> points = new ArrayList<FlatPoint>(this.side);
        double radius = box.getHeight() / 2.0;
        double perSideArc = Math.PI * 2 / (double)this.side;
        double arc = this.getStartArc(perSideArc);
        for (int i = 0; i < this.side; ++i) {
            double x = box.getX() + Math.cos(arc) * radius;
            double y = box.getY() - Math.sin(arc) * radius;
            points.add(new FlatPoint(x, y));
            arc += perSideArc;
        }
        return points;
    }

    public List<FlatPoint> getPoints() {
        return this.flatPoints;
    }

    private double getStartArc(double perSideArc) {
        double arc = 1.5707963267948966;
        if (this.side % 2 == 1) {
            return arc;
        }
        return arc + perSideArc / 2.0;
    }

    private FlatPoint adjPoint(int idx, boolean isPre) {
        Asserts.illegalArgument(idx < 0 || idx >= this.flatPoints.size(), "Wrong index");
        if (isPre) {
            if (idx == 0) {
                return this.flatPoints.get(this.flatPoints.size() - 1);
            }
            return this.flatPoints.get(idx - 1);
        }
        if (idx == this.flatPoints.size() - 1) {
            return this.flatPoints.get(0);
        }
        return this.flatPoints.get(idx + 1);
    }

    private double expansion(double radius, double height, double width) {
        double perSideArc = Math.PI * 2 / (double)this.side;
        double arc = this.getStartArc(perSideArc);
        double pre = arc - perSideArc;
        double leftUpCornerArc = 1.5707963267948966 + Math.atan(width / height);
        for (int i = 0; !(i >= this.side || pre <= leftUpCornerArc && arc > leftUpCornerArc); arc += perSideArc, ++i) {
            pre = arc;
        }
        FlatPoint p1 = new FlatPoint(Math.cos(pre) * radius, -Math.sin(pre) * radius);
        FlatPoint p2 = new FlatPoint(Math.cos(arc) * radius, -Math.sin(arc) * radius);
        FlatPoint leftUp = new FlatPoint(-width / 2.0, -height / 2.0);
        try {
            FlatPoint intersection = Vectors.lineInters(p1, p2, leftUp, Vectors.ZERO);
            double leftUpToCenterLen = FlatPoint.twoFlatPointDistance(leftUp, Vectors.ZERO);
            double interToCenterLen = FlatPoint.twoFlatPointDistance(intersection, Vectors.ZERO);
            if (leftUpToCenterLen <= interToCenterLen) {
                return 0.0;
            }
            return 2.0 * (leftUpToCenterLen - interToCenterLen) / Math.cos(perSideArc / 2.0);
        }
        catch (UnfeasibleException e) {
            log.error("Can not verify whether the left up is in polyline internal", (Throwable)e);
            return 0.0;
        }
    }

    private static class RegularProxyInvoker
    implements InvocationHandler {
        private final NodeShape nodeShape;
        private final RegularPolylinePropCalc propCalc;

        public RegularProxyInvoker(NodeShape nodeShape, RegularPolylinePropCalc propCalc) {
            this.nodeShape = nodeShape;
            this.propCalc = propCalc;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("in")) {
                return this.propCalc.in((Box)args[0], (FlatPoint)args[1]);
            }
            if (method.getName().equals("minContainerSize")) {
                return this.propCalc.minContainerSize((Double)args[0], (Double)args[1]);
            }
            if (method.getName().equals("getShapePropCalc")) {
                return this.propCalc;
            }
            return method.invoke((Object)this.nodeShape, args);
        }
    }
}

