/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.api.ext;

import java.io.Serializable;
import org.graphper.api.ext.Box;
import org.graphper.api.ext.ShapePropCalc;
import org.graphper.def.FlatPoint;
import org.graphper.def.Vectors;
import org.graphper.util.ValueUtils;

public class StarPropCalc
implements ShapePropCalc,
Serializable {
    private static final long serialVersionUID = 1146903395637968118L;
    public static final double START_ARC = 1.5707963267948966;
    public static final double UNIT_ARC = 0.6283185307179586;
    public static final double AXIS_ARC = 1.2566370614359172;
    public static final double IN_OUT_RATIO = ValueUtils.cos(36.0) + ValueUtils.cos(54.0) * ValueUtils.tan(72.0);

    @Override
    public FlatPoint minContainerSize(double innerHeight, double innerWidth) {
        double l = Math.max(innerHeight, innerWidth) / 2.0;
        double radius = l / Math.pow(ValueUtils.cos(36.0), 2.0) * IN_OUT_RATIO;
        return new FlatPoint(2.0 * radius, 2.0 * radius);
    }

    @Override
    public boolean in(Box box, FlatPoint point) {
        double radius = box.getHeight() / 2.0;
        double arc = 1.5707963267948966;
        FlatPoint[] points = new FlatPoint[5];
        for (int i = 0; i < 5; ++i) {
            points[i] = new FlatPoint(box.getX() + Math.cos(arc) * radius, box.getY() - Math.sin(arc) * radius);
            arc += 1.2566370614359172;
        }
        return this.inCheckTriangle(0, points, point) || this.inCheckTriangle(1, points, point) || this.inCheckTriangle(2, points, point);
    }

    private boolean inCheckTriangle(int idx, FlatPoint[] points, FlatPoint target) {
        FlatPoint right;
        FlatPoint left = this.cornerAdj(idx, points, false);
        if (!Vectors.inAngle(points[idx], left, right = this.cornerAdj(idx, points, true), target)) {
            return false;
        }
        int leftAdjIdx = this.getAdjIdx(idx, false);
        return Vectors.inAngle(left, this.cornerAdj(leftAdjIdx, points, false), this.cornerAdj(leftAdjIdx, points, true), target);
    }

    FlatPoint cornerAdj(int idx, FlatPoint[] points, boolean clockwise) {
        int adj = this.getAdjIdx(idx, clockwise);
        return points[adj];
    }

    private int getAdjIdx(int idx, boolean clockwise) {
        int adj;
        adj = clockwise ? ((adj = idx - 2) < 0 ? 5 + adj : adj) : (idx + 2) % 5;
        return adj;
    }
}

