/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.api.ext;

import java.io.Serializable;
import org.graphper.api.ext.Box;
import org.graphper.api.ext.ShapePropCalc;
import org.graphper.def.FlatPoint;
import org.graphper.def.Vectors;

public class TrapeziumPropCalc
implements ShapePropCalc,
Serializable {
    private static final long serialVersionUID = 4151640946566130589L;

    @Override
    public FlatPoint minContainerSize(double innerHeight, double innerWidth) {
        return new FlatPoint(innerHeight, 2.0 * innerWidth);
    }

    @Override
    public boolean in(Box box, FlatPoint point) {
        double left = box.getLeftBorder();
        double right = box.getRightBorder();
        double up = box.getUpBorder();
        double down = box.getDownBorder();
        double leftTopX = box.getLeftBorder() + box.getWidth() / 4.0;
        double rightTopX = box.getRightBorder() - box.getWidth() / 4.0;
        return Vectors.inAngle(left, down, leftTopX, up, right, down, point.getX(), point.getY()) && Vectors.inAngle(right, down, rightTopX, up, left, down, point.getX(), point.getY()) && Vectors.inAngle(leftTopX, up, left, down, rightTopX, up, point.getX(), point.getY());
    }
}

