/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.api.ext;

import java.io.Serializable;
import org.graphper.api.ext.Box;
import org.graphper.api.ext.ShapePropCalc;
import org.graphper.def.FlatPoint;
import org.graphper.def.Vectors;

public class TrianglePropCalc
implements ShapePropCalc,
Serializable {
    private static final long serialVersionUID = 5056940900129881225L;

    @Override
    public FlatPoint minContainerSize(double innerHeight, double innerWidth) {
        double a = 2.0 * Math.sqrt(innerWidth * innerWidth + 4.0 * innerHeight * innerHeight);
        double h = 3.0 * innerHeight * innerWidth / a + 1.5 * innerHeight;
        h = Math.max(h, 2.0 * innerHeight);
        return new FlatPoint(h, h * innerWidth / innerHeight);
    }

    @Override
    public boolean in(Box box, FlatPoint point) {
        double left = box.getX() - box.getWidth() / 2.0;
        double right = box.getX() + box.getWidth() / 2.0;
        double top = box.getY() - box.getHeight() / 2.0;
        double bottom = box.getY() + box.getHeight() / 2.0;
        return Vectors.inAngle(left, bottom, box.getX(), top, right, bottom, point.getX(), point.getY()) && Vectors.inAngle(right, bottom, box.getX(), top, right, bottom, point.getX(), point.getY());
    }

    @Override
    public FlatPoint labelCenter(FlatPoint labelSize, Box box) {
        box.check();
        double y = box.getUpBorder() + 1.5 * labelSize.getHeight();
        return new FlatPoint(box.getX(), y);
    }
}

