/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.def;

import org.graphper.def.BaseEdge;
import org.graphper.def.BaseGraph;
import org.graphper.def.Digraph;
import org.graphper.def.DirectedEdge;
import org.graphper.def.Edge;
import org.graphper.def.EdgeOpGraph;
import org.graphper.def.Graph;
import org.graphper.def.VertexOpGraph;

public abstract class AbstractBaseGraph<V>
implements BaseGraph<V> {
    protected AbstractBaseGraph() {
    }

    @Override
    public int maxDegree() {
        int maxDegree = 0;
        for (Object value : this) {
            int d = this.degree(value);
            if (d <= maxDegree) continue;
            maxDegree = d;
        }
        return maxDegree;
    }

    @Override
    public double averageDegree() {
        return this.vertexNum() != 0 ? 2.0 * (double)this.edgeNum() / (double)this.vertexNum() : 0.0;
    }

    public static abstract class AbstractEdgeOpDigraph<V, E extends DirectedEdge<V, E>>
    extends AbstractEdgeOpBase<V, E>
    implements Digraph.EdgeDigraph<V, E> {
        @Override
        public int degree(V v) {
            int degree = 0;
            for (DirectedEdge ignored : this.adjacent(v)) {
                ++degree;
            }
            Digraph digraph = this.reverse();
            for (DirectedEdge ignored : digraph.adjacent(v)) {
                ++degree;
            }
            return degree;
        }
    }

    public static abstract class AbstractEdgeOpGraph<V, E extends Edge<V, E>>
    extends AbstractEdgeOpBase<V, E>
    implements Graph.EdgeGraph<V, E> {
        @Override
        public int degree(V v) {
            int degree = 0;
            for (Edge ignored : this.adjacent(v)) {
                ++degree;
            }
            return degree;
        }
    }

    public static abstract class AbstractEdgeOpBase<V, E extends BaseEdge<V, E>>
    extends AbstractBaseGraph<V>
    implements EdgeOpGraph<V, E> {
        public String toString() {
            StringBuilder print = new StringBuilder("vertices " + this.vertexNum() + ", edges:" + this.edgeNum() + "\n");
            for (Object v : this) {
                print.append("[").append(v).append("]\n");
                for (BaseEdge e : this.adjacent(v)) {
                    print.append(e).append("\n");
                }
                print.append("\n");
            }
            return print.toString();
        }
    }

    public static abstract class AbstractVertexOpDigraph<V>
    extends AbstractVertexOpBase<V>
    implements Digraph.VertexDigraph<V> {
        @Override
        public int degree(V v) {
            int degree = 0;
            for (Object ignored : this.adjacent(v)) {
                ++degree;
            }
            Digraph digraph = this.reverse();
            for (Object ignored : digraph.adjacent(v)) {
                ++degree;
            }
            return degree;
        }
    }

    public static abstract class AbstractVertexOpGraph<V>
    extends AbstractVertexOpBase<V>
    implements Graph.VertexGraph<V> {
        @Override
        public int degree(V v) {
            int degree = 0;
            for (Object ignored : this.adjacent(v)) {
                ++degree;
            }
            return degree;
        }
    }

    public static abstract class AbstractVertexOpBase<V>
    extends AbstractBaseGraph<V>
    implements VertexOpGraph<V> {
        public String toString() {
            StringBuilder print = new StringBuilder("vertices " + this.vertexNum() + ", edges:" + this.edgeNum() + "\n");
            for (Object v : this) {
                print.append("[").append(v).append("] ");
                for (Object n : this.adjacent(v)) {
                    print.append(v).append(":").append(n).append(" ");
                }
                print.append("\n");
            }
            return print.toString();
        }
    }
}

