/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.def;

import java.io.Serializable;
import java.util.Objects;
import org.graphper.def.BaseEdge;
import org.graphper.util.Asserts;

public abstract class AbstractEdge<V, E extends AbstractEdge<V, E>>
implements BaseEdge<V, E>,
Serializable {
    private static final long serialVersionUID = -7932182426978603206L;
    protected final V left;
    protected final V right;
    protected final double weight;

    protected AbstractEdge(V left, V right) {
        this(left, right, 0.0);
    }

    protected AbstractEdge(V left, V right, double weight) {
        Asserts.nullArgument(left, "left");
        Asserts.nullArgument(left, "right");
        this.left = left;
        this.right = right;
        this.weight = weight;
    }

    protected AbstractEdge(E edge) {
        Objects.requireNonNull(edge);
        this.left = ((AbstractEdge)edge).left;
        this.right = ((AbstractEdge)edge).right;
        this.weight = ((AbstractEdge)edge).weight;
    }

    @Override
    public double weight() {
        return this.weight;
    }

    @Override
    public V either() {
        return this.left;
    }

    @Override
    public V other(V v) {
        if (v == this.left) {
            return this.right;
        }
        if (v == this.right) {
            return this.left;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractEdge)) {
            return false;
        }
        AbstractEdge edge = (AbstractEdge)obj;
        return Objects.equals(edge.left, this.left) && Objects.equals(edge.right, this.right) && Objects.equals(edge.weight, this.weight);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode += this.left.hashCode();
        hashCode += this.right.hashCode();
        hashCode = (int)((double)hashCode + this.weight);
        return hashCode;
    }

    public String toString() {
        return "AbstractEdge{left=" + this.left + ", right=" + this.right + ", weight=" + this.weight + '}';
    }
}

