/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.def;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.graphper.def.AbstractBaseGraph;
import org.graphper.def.Bag;
import org.graphper.def.BaseEdge;
import org.graphper.def.VertexIndex;

abstract class AdjEdgeGraph<V, E extends BaseEdge<V, E>>
extends AbstractBaseGraph.AbstractEdgeOpBase<V, E>
implements Serializable {
    private static final long serialVersionUID = -7783803325974568478L;
    private static final int DEFAULT_CAPACITY = 32;
    int vertexNum;
    int edgeNum;
    transient EdgeBag<V, E>[] bags;
    protected transient int modCount;
    private transient VertexIndex.GraphRef graphRef;

    AdjEdgeGraph() {
        this.bags = new EdgeBag[32];
    }

    AdjEdgeGraph(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + capacity);
        }
        this.bags = new EdgeBag[capacity];
    }

    AdjEdgeGraph(E[] edges) {
        this();
        if (edges == null || edges.length == 0) {
            throw new IllegalArgumentException("edges can not be empty");
        }
        for (E edge : edges) {
            this.addEdge(edge);
        }
    }

    @Override
    public int vertexNum() {
        return this.vertexNum;
    }

    @Override
    public int edgeNum() {
        return this.edgeNum;
    }

    @Override
    public boolean add(V v) {
        Objects.requireNonNull(v);
        EdgeBag bag = (EdgeBag)this.adjacent(v);
        if (bag != EdgeBag.EMPTY) {
            return false;
        }
        this.addBag(v);
        return true;
    }

    @Override
    public Iterable<E> adjacent(Object v) {
        if (v == null) {
            return EdgeBag.EMPTY;
        }
        if (v instanceof VertexIndex) {
            Integer index = ((VertexIndex)v).getGraphIndex().get(this.checkAndReturnGraphRef());
            if (index == null) {
                return EdgeBag.EMPTY;
            }
            if (index >= 0 && index < this.vertexNum && v.equals(this.bags[index.intValue()].vertex)) {
                return this.bags[index];
            }
        }
        return this.position(v);
    }

    @Override
    public Iterable<E> edges() {
        ArrayList<BaseEdge> edges = null;
        for (int i = 0; i < this.vertexNum; ++i) {
            if (edges == null) {
                edges = new ArrayList<BaseEdge>(this.edgeNum);
            }
            for (BaseEdge e : this.adjacent(this.bags[i].vertex)) {
                edges.add(e);
            }
        }
        return edges == null ? Collections.emptyList() : edges;
    }

    @Override
    public void forEachEdges(Consumer<E> action) {
        Objects.requireNonNull(action);
        for (int i = 0; i < this.vertexNum; ++i) {
            for (BaseEdge e : this.adjacent(this.bags[i].vertex)) {
                action.accept(e);
            }
        }
    }

    @Override
    public void forEach(Consumer<? super V> action) {
        Objects.requireNonNull(action);
        for (int i = 0; i < this.vertexNum; ++i) {
            action.accept(this.bags[i].vertex);
        }
    }

    @Override
    public int degree(V vertex) {
        EdgeBag v = (EdgeBag)this.adjacent(vertex);
        return v != EdgeBag.EMPTY ? v.degree : 0;
    }

    @Override
    public int selfLoops(V v) {
        return ((EdgeBag)this.adjacent(v)).loopNum;
    }

    @Override
    public int numberOfLoops() {
        int count = 0;
        for (int i = 0; i < this.vertexNum; ++i) {
            count += this.bags[i].loopNum;
        }
        return count;
    }

    @Override
    public V[] toArray() {
        if (this.vertexNum <= 0) {
            return null;
        }
        Class<?> clazz = this.bags[0].vertex.getClass();
        Object[] vertexs = (Object[])Array.newInstance(clazz, this.vertexNum);
        for (int i = 0; i < this.vertexNum; ++i) {
            vertexs[i] = this.bags[i].vertex;
        }
        return vertexs;
    }

    @Override
    public abstract AdjEdgeGraph<V, E> copy();

    @Override
    public void clear() {
        this.vertexNum = 0;
        this.edgeNum = 0;
        this.modCount = 0;
        this.graphRef = null;
        this.bags = new EdgeBag[32];
    }

    protected EdgeBag<V, E> addBag(V v) {
        if (this.vertexNum == this.bags.length) {
            this.resize();
        }
        int vn = this.vertexNum++;
        EdgeBag bag = new EdgeBag(v);
        this.bags[vn] = bag;
        if (v instanceof VertexIndex) {
            ((VertexIndex)v).getGraphIndex().put(this.checkAndReturnGraphRef(), vn);
        }
        ++this.modCount;
        return bag;
    }

    private void resize() {
        int critical = this.rightRangeMinPowerOf2();
        int newCap = this.vertexNum < critical - (critical >>> 2) ? critical : critical << 1;
        this.bags = Arrays.copyOf(this.bags, newCap);
    }

    private int rightRangeMinPowerOf2() {
        int capacity = this.bags.length;
        return (capacity & 1 << 32 - Integer.numberOfLeadingZeros(capacity) - 1) << 1;
    }

    protected VertexIndex.GraphRef checkAndReturnGraphRef() {
        if (this.graphRef == null) {
            this.graphRef = new VertexIndex.GraphRef(this);
        }
        return this.graphRef;
    }

    private EdgeBag<V, E> position(Object v) {
        for (int i = 0; i < this.vertexNum; ++i) {
            if (!v.equals(this.bags[i].vertex)) continue;
            return this.bags[i];
        }
        return EdgeBag.EMPTY;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdjEdgeGraph that = (AdjEdgeGraph)o;
        if (this.vertexNum != that.vertexNum || this.edgeNum != that.edgeNum) {
            return false;
        }
        for (int i = 0; i < this.vertexNum; ++i) {
            if (Objects.equals(this.bags[i], that.bags[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = Objects.hash(this.vertexNum, this.edgeNum);
        result = 31 * result;
        for (int i = 0; i < this.vertexNum; ++i) {
            result += this.bags[i].hashCode();
        }
        return result;
    }

    protected EdgeBag<V, E>[] bagRepl() {
        EdgeBag[] newBag = new EdgeBag[this.bags.length];
        for (int i = 0; i < this.vertexNum; ++i) {
            newBag[i] = this.bags[i].clone();
        }
        return newBag;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        for (int i = 0; i < this.vertexNum; ++i) {
            oos.writeObject(this.bags[i]);
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (this.vertexNum >= 0) {
            this.bags = new EdgeBag[this.vertexNum];
            for (int i = 0; i < this.vertexNum; ++i) {
                this.bags[i] = (EdgeBag)ois.readObject();
                if (!(this.bags[i].vertex instanceof VertexIndex)) continue;
                VertexIndex vertexIndex = (VertexIndex)this.bags[i].vertex;
                vertexIndex.getGraphIndex().put(this.checkAndReturnGraphRef(), i);
            }
        }
    }

    protected static class EdgeBag<V, E extends BaseEdge<V, E>>
    extends Bag<V, E>
    implements Cloneable {
        private static final long serialVersionUID = -4204284993141072092L;
        static final EdgeBag<?, ?> EMPTY = new EdgeBag((Boolean)true);
        int degree;
        int loopNum;

        EdgeBag(V vertex) {
            super(vertex);
        }

        EdgeBag(Boolean unmodify) {
            super(unmodify);
        }

        @Override
        public Iterator<E> iterator() {
            return new EdgeBagIterator();
        }

        @Override
        void add(E e) {
            super.add(e);
            ++this.degree;
        }

        @Override
        boolean remove(Object edge) {
            if (super.remove(edge)) {
                --this.degree;
                return true;
            }
            return false;
        }

        @Override
        boolean removeIf(Predicate<E> predicate) {
            if (super.removeIf(predicate)) {
                --this.degree;
                return true;
            }
            return false;
        }

        public EdgeBag<V, E> clone() {
            EdgeBag bag = new EdgeBag(this.vertex);
            bag.loopNum = this.loopNum;
            bag.degree = this.degree;
            for (BaseEdge e : this) {
                bag.add((E)e.copy());
                --bag.degree;
            }
            return bag;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EdgeBag edgeBag = (EdgeBag)o;
            return this.degree == edgeBag.degree && this.loopNum == edgeBag.loopNum;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.degree, this.loopNum);
        }

        private class EdgeBagIterator
        extends Bag.BagIterator {
            private EdgeBagIterator() {
                super(EdgeBag.this);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Adjacent Iterator not support delete!");
            }
        }
    }

    protected class AdjIterator
    implements Iterator<V> {
        int index;
        int exceptModCount;

        protected AdjIterator() {
            this.exceptModCount = AdjEdgeGraph.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.index < AdjEdgeGraph.this.vertexNum;
        }

        @Override
        public V next() {
            this.checkIsConcurrentModify();
            if (this.index > AdjEdgeGraph.this.vertexNum) {
                throw new NoSuchElementException();
            }
            return AdjEdgeGraph.this.bags[this.index++].vertex;
        }

        void checkIsConcurrentModify() {
            if (this.exceptModCount != AdjEdgeGraph.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

