/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.def;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.graphper.def.AbstractBaseGraph;
import org.graphper.def.Bag;
import org.graphper.def.VertexIndex;

abstract class AdjVertexGraph<V>
extends AbstractBaseGraph.AbstractVertexOpBase<V>
implements Serializable {
    private static final long serialVersionUID = -4561713639260362179L;
    static final int DEFAULT_CAPACITY = 32;
    int vertexNum;
    int edgeNum;
    transient VertexBag<V>[] bags;
    protected transient int modCount;
    private transient VertexIndex.GraphRef graphRef;

    AdjVertexGraph() {
        this.bags = new VertexBag[32];
    }

    AdjVertexGraph(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + capacity);
        }
        this.bags = new VertexBag[capacity];
    }

    AdjVertexGraph(V[] vertices) {
        if (vertices == null || vertices.length == 0) {
            throw new IllegalArgumentException("vertices can not be empty");
        }
        int length = vertices.length;
        this.bags = new VertexBag[length];
        for (int i = 0; i < length; ++i) {
            V v = vertices[i];
            if (null == v) continue;
            this.bags[i] = new VertexBag<V>(v);
            if (v instanceof VertexIndex) {
                ((VertexIndex)v).getGraphIndex().put(this.checkAndReturnGraphRef(), i);
            }
            ++this.vertexNum;
        }
    }

    @Override
    public int vertexNum() {
        return this.vertexNum;
    }

    @Override
    public int edgeNum() {
        return this.edgeNum;
    }

    @Override
    public boolean add(V v) {
        Objects.requireNonNull(v);
        VertexBag bag = (VertexBag)this.adjacent(v);
        if (bag != VertexBag.EMPTY) {
            return false;
        }
        this.addBag(v);
        return true;
    }

    @Override
    public Iterable<V> adjacent(Object v) {
        if (v == null) {
            return VertexBag.EMPTY;
        }
        if (v instanceof VertexIndex) {
            Integer index = ((VertexIndex)v).getGraphIndex().get(this.checkAndReturnGraphRef());
            if (index == null) {
                return VertexBag.EMPTY;
            }
            if (index >= 0 && index < this.vertexNum && v.equals(this.bags[index.intValue()].vertex)) {
                return this.bags[index];
            }
        }
        return this.position(v);
    }

    @Override
    public void forEach(Consumer<? super V> action) {
        Objects.requireNonNull(action);
        for (int i = 0; i < this.vertexNum; ++i) {
            action.accept(this.bags[i].vertex);
        }
    }

    @Override
    public int degree(V vertex) {
        VertexBag v = (VertexBag)this.adjacent(vertex);
        return v != VertexBag.EMPTY ? v.degree : 0;
    }

    @Override
    public int selfLoops(V v) {
        return ((VertexBag)this.adjacent(v)).loopNum;
    }

    @Override
    public int numberOfLoops() {
        int count = 0;
        for (int i = 0; i < this.vertexNum; ++i) {
            count += this.bags[i].loopNum;
        }
        return count;
    }

    @Override
    public V[] toArray() {
        if (this.vertexNum <= 0) {
            return null;
        }
        Class<?> clazz = this.bags[0].vertex.getClass();
        Object[] vertexs = (Object[])Array.newInstance(clazz, this.vertexNum);
        for (int i = 0; i < this.vertexNum; ++i) {
            vertexs[i] = this.bags[i].vertex;
        }
        return vertexs;
    }

    @Override
    public abstract AdjVertexGraph<V> copy();

    @Override
    public void clear() {
        this.vertexNum = 0;
        this.edgeNum = 0;
        this.modCount = 0;
        this.graphRef = null;
        this.bags = new VertexBag[32];
    }

    protected VertexBag<V> addBag(V v) {
        if (this.vertexNum == this.bags.length) {
            this.resize();
        }
        int vn = this.vertexNum++;
        VertexBag<V> bag = new VertexBag<V>(v);
        this.bags[vn] = bag;
        if (v instanceof VertexIndex) {
            ((VertexIndex)v).getGraphIndex().put(this.checkAndReturnGraphRef(), vn);
        }
        ++this.modCount;
        return bag;
    }

    private void resize() {
        int critical = this.rightRangeMinPowerOf2();
        int newCap = this.vertexNum < critical - (critical >>> 2) ? critical : critical << 1;
        this.bags = Arrays.copyOf(this.bags, newCap);
    }

    private int rightRangeMinPowerOf2() {
        int capacity = this.bags.length;
        return (capacity & 1 << 32 - Integer.numberOfLeadingZeros(capacity) - 1) << 1;
    }

    protected VertexIndex.GraphRef checkAndReturnGraphRef() {
        if (this.graphRef == null) {
            this.graphRef = new VertexIndex.GraphRef(this);
        }
        return this.graphRef;
    }

    private VertexBag<V> position(Object v) {
        for (int i = 0; i < this.vertexNum; ++i) {
            if (!v.equals(this.bags[i].vertex)) continue;
            return this.bags[i];
        }
        return VertexBag.EMPTY;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdjVertexGraph that = (AdjVertexGraph)o;
        if (this.vertexNum != that.vertexNum || this.edgeNum != that.edgeNum) {
            return false;
        }
        for (int i = 0; i < this.vertexNum; ++i) {
            if (Objects.equals(this.bags[i], that.bags[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = Objects.hash(this.vertexNum, this.edgeNum);
        result = 31 * result;
        for (int i = 0; i < this.vertexNum; ++i) {
            result += this.bags[i].hashCode();
        }
        return result;
    }

    protected VertexBag<V>[] bagRepl() {
        VertexBag[] newBag = new VertexBag[this.bags.length];
        for (int i = 0; i < this.vertexNum; ++i) {
            newBag[i] = this.bags[i].clone();
        }
        return newBag;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        for (int i = 0; i < this.vertexNum; ++i) {
            oos.writeObject(this.bags[i]);
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (this.vertexNum >= 0) {
            this.bags = new VertexBag[this.vertexNum];
            for (int i = 0; i < this.vertexNum; ++i) {
                this.bags[i] = (VertexBag)ois.readObject();
                if (!(this.bags[i].vertex instanceof VertexIndex)) continue;
                VertexIndex vertexIndex = (VertexIndex)this.bags[i].vertex;
                vertexIndex.getGraphIndex().put(this.checkAndReturnGraphRef(), i);
            }
        }
    }

    protected static class VertexBag<V>
    extends Bag<V, V>
    implements Cloneable {
        private static final long serialVersionUID = -2484420246227776869L;
        static final VertexBag<?> EMPTY = new VertexBag((Boolean)true);
        int degree;
        int loopNum;

        VertexBag(V vertex) {
            super(vertex);
        }

        VertexBag(Boolean unmodify) {
            super(unmodify);
        }

        @Override
        public Iterator<V> iterator() {
            return new VertexBagIterator();
        }

        @Override
        void add(V vertex) {
            super.add(vertex);
            ++this.degree;
        }

        @Override
        boolean remove(Object vertex) {
            if (super.remove(vertex)) {
                --this.degree;
                return true;
            }
            return false;
        }

        @Override
        boolean removeIf(Predicate<V> predicate) {
            if (super.removeIf(predicate)) {
                --this.degree;
                return true;
            }
            return false;
        }

        public VertexBag<V> clone() {
            VertexBag<Object> bag = new VertexBag<Object>(this.vertex);
            bag.loopNum = this.loopNum;
            bag.degree = this.degree;
            for (V e : this) {
                bag.add(e);
                --bag.degree;
            }
            return bag;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            VertexBag vertexBag = (VertexBag)o;
            return this.degree == vertexBag.degree && this.loopNum == vertexBag.loopNum;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.degree, this.loopNum);
        }

        private class VertexBagIterator
        extends Bag.BagIterator {
            private VertexBagIterator() {
                super(VertexBag.this);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Adjacent Iterator not support delete!");
            }
        }
    }

    protected class AdjIterator
    implements Iterator<V> {
        int index;
        int exceptModCount;

        protected AdjIterator() {
            this.exceptModCount = AdjVertexGraph.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.index < AdjVertexGraph.this.vertexNum;
        }

        @Override
        public V next() {
            this.checkIsConcurrentModify();
            if (this.index > AdjVertexGraph.this.vertexNum) {
                throw new NoSuchElementException();
            }
            return AdjVertexGraph.this.bags[this.index++].vertex;
        }

        void checkIsConcurrentModify() {
            if (this.exceptModCount != AdjVertexGraph.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

