/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.def;

import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.graphper.def.UnmodifiableBagException;

class Bag<V, E>
implements Iterable<E>,
Serializable {
    private static final long serialVersionUID = -3433776704595616074L;
    Boolean unmodify;
    final V vertex;
    Node<E> header;
    Node<E> tail;
    transient int bModCount;

    Bag(V vertex) {
        this.vertex = vertex;
    }

    Bag(boolean unmodify) {
        this.vertex = null;
        this.unmodify = unmodify;
    }

    @Override
    public Iterator<E> iterator() {
        return new BagIterator();
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        Node<E> current = this.header;
        while (current != null) {
            action.accept(current.value);
            current = current.next;
        }
    }

    void add(E e) {
        this.checkIsUnmodify();
        if (this.header == null) {
            this.header = new Node<E>(e, null, null);
            this.tail = this.header;
        } else {
            this.tail.next = new Node<E>(e, this.tail, null);
            this.tail = this.tail.next;
        }
        ++this.bModCount;
    }

    boolean remove(Object obj) {
        this.checkIsUnmodify();
        Node<E> current = this.header;
        while (current != null && !Objects.equals(current.value, obj)) {
            current = current.next;
        }
        if (current == null) {
            return false;
        }
        if (current == this.tail) {
            this.tail = this.tail.pre;
            if (this.tail != null) {
                this.tail.next = null;
            } else {
                this.header = null;
            }
        } else if (current == this.header) {
            this.header = this.header.next;
            this.header.pre = null;
        } else {
            Node pre = current.pre;
            if (pre != null) {
                pre.next = current.next;
                current.next.pre = pre;
            }
        }
        ++this.bModCount;
        return true;
    }

    boolean removeIf(Predicate<E> predicate) {
        Objects.requireNonNull(predicate);
        this.checkIsUnmodify();
        Node<E> point = this.header;
        while (point != null) {
            if (predicate.test(point.value)) {
                Node pre = point.pre;
                Node next = point.next;
                if (pre != null) {
                    pre.next = next;
                }
                if (next != null) {
                    next.pre = pre;
                }
                if (point == this.header) {
                    this.header = next;
                }
                if (point == this.tail) {
                    this.tail = pre;
                }
                ++this.bModCount;
                return true;
            }
            point = point.next;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Bag)) {
            return false;
        }
        Bag bag = (Bag)obj;
        if (!Objects.equals(this.unmodify, bag.unmodify)) {
            return false;
        }
        if (!Objects.equals(this.vertex, bag.vertex)) {
            return false;
        }
        if (!Objects.equals(this.getNodeValue(this.header), this.getNodeValue(bag.header))) {
            return false;
        }
        if (!Objects.equals(this.getNodeValue(this.tail), this.getNodeValue(bag.tail))) {
            return false;
        }
        Node<E> c1 = this.header;
        Node<E> c2 = bag.header;
        while (Objects.equals(this.getNodeValue(c1), this.getNodeValue(c2)) && Objects.nonNull(c1)) {
            c1 = c1.next;
            c2 = c2.next;
        }
        return c1 == null && c2 == null;
    }

    public int hashCode() {
        int hashCode = this.vertex != null ? this.vertex.hashCode() : 1;
        Node<E> point = this.header;
        while (point != null) {
            hashCode = point.value != null ? (hashCode += point.value.hashCode()) : ++hashCode;
            point = point.next;
        }
        return hashCode += Bag.class.hashCode();
    }

    void checkIsUnmodify() {
        if (this.unmodify != null && this.unmodify.booleanValue()) {
            throw new UnmodifiableBagException("Bag cannot be modify");
        }
    }

    private Object getNodeValue(Node<?> node) {
        if (node == null) {
            return null;
        }
        return node.value;
    }

    private static final class Node<E>
    implements Serializable {
        private static final long serialVersionUID = 6069018214912306217L;
        final E value;
        Node<E> pre;
        Node<E> next;

        Node(E value) {
            this.value = value;
        }

        Node(E value, Node<E> pre, Node<E> next) {
            this(value);
            this.pre = pre;
            this.next = next;
        }
    }

    protected class BagIterator
    implements Iterator<E> {
        Node<E> point;
        private int exceptModCount;

        BagIterator() {
            this.exceptModCount = Bag.this.bModCount;
            this.point = Bag.this.header;
        }

        @Override
        public boolean hasNext() {
            return this.point != null;
        }

        @Override
        public E next() {
            this.checkIsConcurrentModify();
            if (this.point == null) {
                throw new NoSuchElementException();
            }
            Object value = this.point.value;
            this.point = this.point.next;
            return value;
        }

        @Override
        public void remove() {
            Bag.this.checkIsUnmodify();
            this.checkIsConcurrentModify();
            if (this.point == Bag.this.header) {
                throw new IllegalStateException("Iterator not specified");
            }
            if (this.point == null) {
                if (Bag.this.tail != null) {
                    Bag.this.tail = Bag.this.tail.pre;
                    if (Bag.this.tail != null) {
                        Bag.this.tail.next = null;
                    } else {
                        Bag.this.header = null;
                    }
                }
            } else {
                Node prepre;
                Node pre = this.point.pre;
                if (pre == Bag.this.header) {
                    Bag.this.header = Bag.this.header.next;
                    Bag.this.header.pre = null;
                } else if (pre != null && (prepre = pre.pre) != null) {
                    prepre.next = this.point;
                    this.point.pre = prepre;
                }
            }
            ++this.exceptModCount;
            ++Bag.this.bModCount;
        }

        private void checkIsConcurrentModify() {
            if (this.exceptModCount != Bag.this.bModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

