/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.def;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graphper.util.Asserts;
import org.graphper.util.CollectionUtils;

public class ConcatIterable<P, T>
implements Iterable<T> {
    private final Collection<? extends Iterable<? extends P>> iterables;
    private final Predicate<? super T> filter;
    private final Function<? super P, ? extends T> converter;

    @SafeVarargs
    public ConcatIterable(Function<? super P, ? extends T> converter, Iterable<? extends P> ... iterables) {
        this(converter, Stream.of(iterables).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    @SafeVarargs
    public ConcatIterable(Predicate<? super T> filter, Function<? super P, ? extends T> converter, Iterable<? extends P> ... iterables) {
        this(filter, converter, Stream.of(iterables).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    public ConcatIterable(Function<? super P, ? extends T> converter, Collection<? extends Iterable<? extends P>> iterables) {
        this((Predicate<? extends T>)null, converter, (Collection<Iterable<? super P>>)iterables);
    }

    public ConcatIterable(Predicate<? super T> filter, Function<? super P, ? extends T> converter, Collection<? extends Iterable<? extends P>> iterables) {
        Asserts.illegalArgument(CollectionUtils.isEmpty(iterables), "iterables is empty!");
        Asserts.nullArgument(converter, "converter");
        this.iterables = iterables;
        this.filter = filter;
        this.converter = converter;
    }

    @Override
    public Iterator<T> iterator() {
        Iterator iterator = this.iterables.stream().map(Iterable::iterator).filter(Iterator::hasNext).collect(Collectors.toList()).iterator();
        if (!iterator.hasNext()) {
            return Collections.emptyIterator();
        }
        if (this.filter == null) {
            return new ConcatIterator(iterator, this.converter);
        }
        return new FilterContactIterator(iterator, this.converter, this.filter);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConcatIterable that = (ConcatIterable)o;
        return Objects.equals(this.iterables, that.iterables) && Objects.equals(this.filter, that.filter) && Objects.equals(this.converter, that.converter);
    }

    public int hashCode() {
        return Objects.hash(this.iterables, this.filter, this.converter);
    }

    public static final class FilterContactIterator<P, T>
    extends ConcatIterator<P, T> {
        private T current;
        private boolean currentIsConsumer = true;
        private final Predicate<? super T> filter;

        private FilterContactIterator(Iterator<? extends Iterator<? extends P>> iterators, Function<? super P, ? extends T> converter, Predicate<? super T> filter) {
            super(iterators, converter);
            Asserts.nullArgument(filter, "filter");
            this.filter = filter;
        }

        @Override
        public boolean hasNext() {
            if (!super.hasNext()) {
                if (this.current == null) {
                    return false;
                }
                return !this.currentIsConsumer;
            }
            if (!this.currentIsConsumer) {
                return true;
            }
            do {
                this.current = this.safeNext();
            } while (!this.filter.test(this.current) && super.hasNext());
            if (!super.hasNext() && !this.filter.test(this.current)) {
                return false;
            }
            this.currentIsConsumer = false;
            return true;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.currentIsConsumer = true;
            return this.current;
        }

        private T safeNext() {
            if (super.hasNext()) {
                return super.next();
            }
            return null;
        }
    }

    private static class ConcatIterator<P, T>
    implements Iterator<T> {
        private final Iterator<? extends Iterator<? extends P>> iterators;
        private Iterator<? extends P> curItr;
        private final Function<? super P, ? extends T> converter;

        private ConcatIterator(Iterator<? extends Iterator<? extends P>> iterators, Function<? super P, ? extends T> converter) {
            this.iterators = iterators;
            this.converter = converter;
        }

        @Override
        public boolean hasNext() {
            if (this.iterators.hasNext()) {
                return true;
            }
            if (this.curItr == null) {
                return false;
            }
            return this.curItr.hasNext();
        }

        @Override
        public T next() {
            if (this.curItr == null) {
                this.curItr = this.iterators.next();
            }
            if (this.curItr.hasNext()) {
                return this.converter.apply(this.curItr.next());
            }
            if (!this.iterators.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curItr = this.iterators.next();
            return this.converter.apply(this.curItr.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Concat Iterator not support delete!");
        }
    }
}

