/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.def;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.graphper.def.FlatPoint;
import org.graphper.def.Vectors;
import org.graphper.util.Asserts;
import org.graphper.util.CollectionUtils;

public final class Curves {
    private static final int MAX_ITERATIONS_TIMES = 4;

    private Curves() {
    }

    public static <F extends FlatPoint> MultiBezierCurve fitCurves(List<F> points, double error) {
        return Curves.fitCurves(points, null, null, error);
    }

    public static <F extends FlatPoint> MultiBezierCurve fitCurves(List<F> points, FlatPoint leftTangent, FlatPoint rightTangent, double error) {
        Asserts.illegalArgument(CollectionUtils.isEmpty(points) || points.size() < 2, "The number of points must be greater than 1");
        leftTangent = leftTangent == null ? Curves.computeLeftTangent(points) : leftTangent;
        rightTangent = rightTangent == null ? Curves.computeRightTangent(points) : rightTangent;
        return Curves.fitCurves(0, points.size() - 1, error, new MultiBezierCurve(), leftTangent, rightTangent, points);
    }

    public static FlatPoint besselEquationCalc(double t, FlatPoint ... points) {
        Asserts.illegalArgument(points == null || points.length < 2, "points length can not be lower than 2");
        Asserts.illegalArgument(t < 0.0 || t > 1.0, "t must between 0 and 1");
        if (t == 0.0) {
            return points[0];
        }
        if (t == 1.0) {
            return points[points.length - 1];
        }
        FlatPoint[] tmp = Arrays.copyOf(points, points.length);
        for (int i = 0; i < points.length; ++i) {
            for (int j = 0; j < points.length - 1; ++j) {
                Asserts.illegalArgument(tmp[j] == null, "Bessel curve contain null control point");
                Asserts.illegalArgument(tmp[j + 1] == null, "");
                tmp[j] = new FlatPoint((1.0 - t) * tmp[j].getX() + t * tmp[j + 1].getX(), (1.0 - t) * tmp[j].getY() + t * tmp[j + 1].getY());
            }
        }
        return tmp[0];
    }

    public static ThirdOrderBezierCurve divideThirdBesselCurve(double t, boolean isFirstHalf, ThirdOrderBezierCurve bezierCurve) {
        Asserts.illegalArgument(t < 0.0 || t > 1.0, "t must between 0 and 1");
        Asserts.nullArgument(bezierCurve, "bezierCurve");
        FlatPoint dividePoint = Curves.besselEquationCalc(t, bezierCurve.v1, bezierCurve.v2, bezierCurve.v3, bezierCurve.v4);
        FlatPoint intersection = Vectors.add(bezierCurve.v2, Vectors.multiple(Vectors.sub(bezierCurve.v3, bezierCurve.v2), t));
        ThirdOrderBezierCurve childCurve = new ThirdOrderBezierCurve();
        if (isFirstHalf) {
            childCurve.v1 = bezierCurve.v1;
            childCurve.v2 = Vectors.add(bezierCurve.v1, Vectors.multiple(Vectors.sub(bezierCurve.v2, bezierCurve.v1), t));
            childCurve.v3 = Vectors.add(childCurve.v2, Vectors.multiple(Vectors.sub(intersection, childCurve.v2), t));
            childCurve.v4 = dividePoint;
        } else {
            childCurve.v1 = dividePoint;
            childCurve.v3 = Vectors.add(Vectors.multiple(Vectors.sub(bezierCurve.v3, bezierCurve.v4), 1.0 - t), bezierCurve.v4);
            childCurve.v2 = Vectors.add(intersection, Vectors.multiple(Vectors.sub(childCurve.v3, intersection), t));
            childCurve.v4 = bezierCurve.v4;
        }
        return childCurve;
    }

    private static <F extends FlatPoint> MultiBezierCurve fitCurves(int first, int last, double error, MultiBezierCurve curve, FlatPoint leftTangent, FlatPoint rightTangent, List<F> points) {
        if (last - first + 1 == 2) {
            double distance = FlatPoint.twoFlatPointDistance((FlatPoint)points.get(first), (FlatPoint)points.get(last)) / 3.0;
            ThirdOrderBezierCurve thirdOrderBezierCurve = new ThirdOrderBezierCurve();
            thirdOrderBezierCurve.v1 = (FlatPoint)points.get(first);
            thirdOrderBezierCurve.v4 = (FlatPoint)points.get(last);
            thirdOrderBezierCurve.v2 = Vectors.add(thirdOrderBezierCurve.v1, Vectors.scale(leftTangent, distance));
            thirdOrderBezierCurve.v3 = Vectors.add(thirdOrderBezierCurve.v4, Vectors.scale(rightTangent, distance));
            curve.add(thirdOrderBezierCurve);
            return curve;
        }
        double[] pointChordLens = Curves.chordLengthParameterize(points, first, last);
        ThirdOrderBezierCurve bezierCurve = Curves.generateBezier(points, first, last, pointChordLens, leftTangent, rightTangent);
        int[] nArray = new int[]{0};
        int[] splitIndex = nArray;
        double maxError = Curves.computeMaxError(points, first, last, bezierCurve, pointChordLens, splitIndex);
        if (maxError < error) {
            curve.add(bezierCurve);
            return curve;
        }
        double iterationError = error * 4.0;
        if (maxError < iterationError) {
            for (int i = 0; i < 4; ++i) {
                double[] uPrime = Curves.reparameterize(points, first, last, pointChordLens, bezierCurve);
                maxError = Curves.computeMaxError(points, first, last, bezierCurve = Curves.generateBezier(points, first, last, uPrime, leftTangent, rightTangent), uPrime, splitIndex);
                if (maxError < error) {
                    curve.add(bezierCurve);
                    return curve;
                }
                pointChordLens = uPrime;
            }
        }
        FlatPoint centerVector = Curves.computeCenterTangent(points, splitIndex[0]);
        Curves.fitCurves(first, splitIndex[0], error, curve, leftTangent, centerVector, points);
        Curves.fitCurves(splitIndex[0], last, error, curve, centerVector.reserve(), rightTangent, points);
        return curve;
    }

    private static <F extends FlatPoint> ThirdOrderBezierCurve generateBezier(List<F> points, int first, int last, double[] pointChordLens, FlatPoint leftVector, FlatPoint rightVector) {
        double alphaR;
        double alphaL;
        int size = last - first + 1;
        ThirdOrderBezierCurve bezierCurve = new ThirdOrderBezierCurve();
        FlatPoint[][] A = new FlatPoint[size][];
        for (int i = 0; i < size; ++i) {
            A[i] = new FlatPoint[2];
            A[i][0] = Vectors.scale(leftVector, Curves.B1(pointChordLens[i]));
            A[i][1] = Vectors.scale(rightVector, Curves.B2(pointChordLens[i]));
        }
        FlatPoint firstPoint = (FlatPoint)points.get(first);
        FlatPoint lastPoint = (FlatPoint)points.get(last);
        double[][] C = new double[][]{{0.0, 0.0}, {0.0, 0.0}};
        double[] X = new double[]{0.0, 0.0};
        for (int i = 0; i < size; ++i) {
            double[] dArray = C[0];
            dArray[0] = dArray[0] + Vectors.mul(A[i][0], A[i][0]);
            double[] dArray2 = C[0];
            dArray2[1] = dArray2[1] + Vectors.mul(A[i][0], A[i][1]);
            C[1][0] = C[0][1];
            double[] dArray3 = C[1];
            dArray3[1] = dArray3[1] + Vectors.mul(A[i][1], A[i][1]);
            FlatPoint tmp = Vectors.sub((FlatPoint)points.get(first + i), Vectors.add(Vectors.multiple(firstPoint, Curves.B0(pointChordLens[i])), Vectors.add(Vectors.multiple(firstPoint, Curves.B1(pointChordLens[i])), Vectors.add(Vectors.multiple(lastPoint, Curves.B2(pointChordLens[i])), Vectors.multiple(lastPoint, Curves.B3(pointChordLens[i]))))));
            X[0] = X[0] + Vectors.mul(A[i][0], tmp);
            X[1] = X[1] + Vectors.mul(A[i][1], tmp);
        }
        double detC0C1 = C[0][0] * C[1][1] - C[1][0] * C[0][1];
        double detC0X = C[0][0] * X[1] - C[1][0] * X[0];
        double detXC1 = X[0] * C[1][1] - X[1] * C[0][1];
        if (detC0C1 == 0.0) {
            alphaL = 0.0;
            alphaR = 0.0;
        } else {
            alphaL = detXC1 / detC0C1;
            alphaR = detC0X / detC0C1;
        }
        double segLength = FlatPoint.twoFlatPointDistance(firstPoint, lastPoint);
        double epsilon = 1.0E-6 * segLength;
        bezierCurve.v1 = firstPoint;
        bezierCurve.v4 = lastPoint;
        if (alphaL < epsilon || alphaR < epsilon) {
            double dist = segLength / 3.0;
            bezierCurve.v2 = Vectors.add(bezierCurve.v1, Vectors.scale(leftVector, dist));
            bezierCurve.v3 = Vectors.add(bezierCurve.v4, Vectors.scale(rightVector, dist));
        } else {
            bezierCurve.v2 = Vectors.add(bezierCurve.v1, Vectors.scale(leftVector, alphaL));
            bezierCurve.v3 = Vectors.add(bezierCurve.v4, Vectors.scale(rightVector, alphaR));
        }
        return bezierCurve;
    }

    private static <F extends FlatPoint> double computeMaxError(List<F> points, int first, int last, ThirdOrderBezierCurve bezierCurve, double[] pointChordLens, int[] splitIndex) {
        splitIndex[0] = (last - first + 1) / 2;
        double maxDist = -1.7976931348623157E308;
        for (int i = first + 1; i < last; ++i) {
            FlatPoint[] flatPointArray = new FlatPoint[]{bezierCurve.v1, bezierCurve.v2, bezierCurve.v3, bezierCurve.v4};
            FlatPoint p = Curves.besselEquationCalc(pointChordLens[i - first], flatPointArray);
            FlatPoint v = Vectors.sub(p, (FlatPoint)points.get(i));
            double dist = Vectors.squaredLen(v.getX(), v.getY());
            if (!(dist >= maxDist)) continue;
            maxDist = dist;
            splitIndex[0] = i;
        }
        return maxDist;
    }

    private static <F extends FlatPoint> double[] reparameterize(List<F> points, int first, int last, double[] pointChordLens, ThirdOrderBezierCurve bezierCurve) {
        double[] repl = new double[last - first + 1];
        for (int i = first; i <= last; ++i) {
            repl[i - first] = Curves.newtonRaphsonRootFind(bezierCurve, (FlatPoint)points.get(i), pointChordLens[i - first]);
        }
        return repl;
    }

    private static double newtonRaphsonRootFind(ThirdOrderBezierCurve curve, FlatPoint p, double u) {
        int i;
        FlatPoint qu = Curves.besselEquationCalc(u, curve.v1, curve.v2, curve.v3, curve.v4);
        FlatPoint[] q1 = new FlatPoint[3];
        FlatPoint[] q2 = new FlatPoint[2];
        for (i = 0; i <= 2; ++i) {
            q1[i] = new FlatPoint((curve.getByIndex(i + 1).getX() - curve.getByIndex(i).getX()) * 3.0, (curve.getByIndex(i + 1).getY() - curve.getByIndex(i).getY()) * 3.0);
        }
        for (i = 0; i <= 1; ++i) {
            q2[i] = new FlatPoint((q1[i + 1].getX() - q1[i].getX()) * 2.0, (q1[i + 1].getY() - q1[i].getY()) * 2.0);
        }
        FlatPoint q1u = Curves.besselEquationCalc(u, q1);
        FlatPoint q2u = Curves.besselEquationCalc(u, q2);
        double numerator = (qu.getX() - p.getX()) * q1u.getX() + (qu.getY() - p.getY()) * q1u.getY();
        double denominator = q1u.getX() * q1u.getX() + q1u.getY() * q1u.getY() + (qu.getX() - p.getX()) * q2u.getX() + (qu.getY() - p.getY()) * q2u.getY();
        if (denominator == 0.0) {
            return u;
        }
        return u - numerator / denominator;
    }

    private static <F extends FlatPoint> double[] chordLengthParameterize(List<F> points, int first, int last) {
        double[] pointChordLens = new double[last - first + 1];
        for (int i = 1; i < pointChordLens.length; ++i) {
            pointChordLens[i] = pointChordLens[i - 1] + FlatPoint.twoFlatPointDistance((FlatPoint)points.get(first + i), (FlatPoint)points.get(first + i - 1));
        }
        double lastPoint = pointChordLens[pointChordLens.length - 1];
        for (int i = 1; i < pointChordLens.length; ++i) {
            pointChordLens[i] = pointChordLens[i] / lastPoint;
        }
        return pointChordLens;
    }

    private static <F extends FlatPoint> FlatPoint computeLeftTangent(List<F> points) {
        return Vectors.unit((FlatPoint)points.get(1), (FlatPoint)points.get(0));
    }

    private static <F extends FlatPoint> FlatPoint computeRightTangent(List<F> points) {
        return Vectors.unit((FlatPoint)points.get(points.size() - 2), (FlatPoint)points.get(points.size() - 1));
    }

    private static <F extends FlatPoint> FlatPoint computeCenterTangent(List<F> points, int centerIndex) {
        FlatPoint v1 = Vectors.sub((FlatPoint)points.get(centerIndex - 1), (FlatPoint)points.get(centerIndex));
        FlatPoint v2 = Vectors.sub((FlatPoint)points.get(centerIndex), (FlatPoint)points.get(centerIndex + 1));
        return Vectors.unit((v1.getX() + v2.getX()) / 2.0, (v1.getY() + v2.getY()) / 2.0);
    }

    private static double B0(double t) {
        double tmp = 1.0 - t;
        return tmp * tmp * tmp;
    }

    private static double B1(double t) {
        double tmp = 1.0 - t;
        return 3.0 * t * tmp * tmp;
    }

    private static double B2(double t) {
        double tmp = 1.0 - t;
        return 3.0 * t * t * tmp;
    }

    private static double B3(double t) {
        return t * t * t;
    }

    public static class ThirdOrderBezierCurve
    implements Serializable {
        private static final long serialVersionUID = 2766088821979206982L;
        private FlatPoint v1;
        private FlatPoint v2;
        private FlatPoint v3;
        private FlatPoint v4;

        private ThirdOrderBezierCurve() {
        }

        public ThirdOrderBezierCurve(FlatPoint v1, FlatPoint v2, FlatPoint v3, FlatPoint v4) {
            Asserts.nullArgument(v1, "v1");
            Asserts.nullArgument(v2, "v2");
            Asserts.nullArgument(v3, "v3");
            Asserts.nullArgument(v4, "v4");
            this.v1 = v1;
            this.v2 = v2;
            this.v3 = v3;
            this.v4 = v4;
        }

        public FlatPoint getV1() {
            return this.v1;
        }

        public FlatPoint getV2() {
            return this.v2;
        }

        public FlatPoint getV3() {
            return this.v3;
        }

        public FlatPoint getV4() {
            return this.v4;
        }

        public void adjust(double v2AdjustRatio, double v3AdjustRatio) {
            this.v2 = Vectors.add(this.v1, Vectors.scale(Vectors.sub(this.v2, this.v1), FlatPoint.twoFlatPointDistance(this.v2, this.v1) * v2AdjustRatio));
            this.v3 = Vectors.add(this.v4, Vectors.scale(Vectors.sub(this.v3, this.v4), FlatPoint.twoFlatPointDistance(this.v3, this.v4) * v3AdjustRatio));
        }

        private FlatPoint getByIndex(int index) {
            if (index == 0) {
                return this.v1;
            }
            if (index == 1) {
                return this.v2;
            }
            if (index == 2) {
                return this.v3;
            }
            if (index == 3) {
                return this.v4;
            }
            throw new IndexOutOfBoundsException("index must between 0 and 3");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ThirdOrderBezierCurve that = (ThirdOrderBezierCurve)o;
            return Objects.equals(this.v1, that.v1) && Objects.equals(this.v2, that.v2) && Objects.equals(this.v3, that.v3) && Objects.equals(this.v4, that.v4);
        }

        public int hashCode() {
            return Objects.hash(this.v1, this.v2, this.v3, this.v4);
        }

        public String toString() {
            return "ThirdOrderBezierCurve{v1=" + this.v1 + ", v2=" + this.v2 + ", v3=" + this.v3 + ", v4=" + this.v4 + '}';
        }
    }

    public static class MultiBezierCurve
    extends ArrayList<ThirdOrderBezierCurve> {
        private static final long serialVersionUID = -7991103325506043318L;

        public MultiBezierCurve() {
        }

        public MultiBezierCurve(int initialCapacity) {
            super(initialCapacity);
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o) && o instanceof MultiBezierCurve;
        }

        @Override
        public int hashCode() {
            return super.hashCode() + MultiBezierCurve.class.hashCode();
        }
    }
}

