/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.def;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.graphper.def.AbstractEdge;
import org.graphper.def.BiConcatIterable;
import org.graphper.def.DirectedEdge;
import org.graphper.def.DirectedEdgeGraph;
import org.graphper.def.EdgeDedigraph;
import org.graphper.def.ProxyDedigraph;
import org.graphper.util.CollectionUtils;

public class DedirectedEdgeGraph<V, E extends DirectedEdge<V, E>>
extends ProxyDedigraph<V, DirectedEdgeGraph<V, E>, DirectedEdgeGraph<V, ReverseEdge<V, E>>>
implements EdgeDedigraph<V, E> {
    private static final long serialVersionUID = -5712574722294920575L;
    private final HashMap<E, List<ReverseEdge<V, E>>> reverseEdgeMap;

    public DedirectedEdgeGraph() {
        this(new DirectedEdgeGraph(), new DirectedEdgeGraph());
    }

    public DedirectedEdgeGraph(int capacity) {
        this(new DirectedEdgeGraph(capacity), new DirectedEdgeGraph(capacity));
    }

    public DedirectedEdgeGraph(E[] edges) {
        this(new DirectedEdgeGraph(), new DirectedEdgeGraph());
        if (edges == null || edges.length == 0) {
            throw new IllegalArgumentException("edges can not be empty");
        }
        for (E edge : edges) {
            this.addEdge(edge);
        }
    }

    public DedirectedEdgeGraph(Collection<E> edges) {
        this(new DirectedEdgeGraph(), new DirectedEdgeGraph());
        if (CollectionUtils.isEmpty(edges)) {
            throw new IllegalArgumentException("edges can not be empty");
        }
        for (DirectedEdge edge : edges) {
            this.addEdge((E)edge);
        }
    }

    private DedirectedEdgeGraph(DirectedEdgeGraph<V, E> digraph, DirectedEdgeGraph<V, ReverseEdge<V, E>> reDigraph) {
        super(digraph, reDigraph);
        this.reverseEdgeMap = new HashMap(digraph.edgeNum());
        reDigraph.forEachEdges((T edge) -> this.putEdgeMap((E)((ReverseEdge)edge).edge, (ReverseEdge<V, E>)edge));
    }

    @Override
    public void clear() {
        super.clear();
        if (this.reverseEdgeMap != null) {
            this.reverseEdgeMap.clear();
        }
    }

    @Override
    protected Iterable<ReverseEdge<V, E>> inIte(Object v) {
        return ((DirectedEdgeGraph)this.reDigraph).adjacent(v);
    }

    @Override
    protected Iterable<E> outIte(Object v) {
        return ((DirectedEdgeGraph)this.digraph).adjacent(v);
    }

    @Override
    public void addEdge(E e) {
        Objects.requireNonNull(e);
        ((DirectedEdgeGraph)this.digraph).addEdge(e);
        ReverseEdge re = new ReverseEdge(e.to(), e.from(), e.weight(), e);
        this.putEdgeMap(e, re);
        ((DirectedEdgeGraph)this.reDigraph).addEdge(re);
    }

    @Override
    public boolean remove(Object v) {
        for (DirectedEdge e : this.adjacent(v)) {
            List<ReverseEdge<V, E>> reverseEdges = this.reverseEdgeMap.get(e);
            if (CollectionUtils.isEmpty(reverseEdges)) continue;
            reverseEdges.remove(reverseEdges.size() - 1);
            if (!CollectionUtils.isEmpty(reverseEdges)) continue;
            this.reverseEdgeMap.remove(e);
        }
        return super.remove(v);
    }

    @Override
    public boolean removeEdge(E e) {
        if (this.vertexNum() == 0 || this.edgeNum() == 0 || e == null) {
            return false;
        }
        boolean result = ((DirectedEdgeGraph)this.digraph).removeEdge(e);
        if (!result) {
            return false;
        }
        List<ReverseEdge<V, E>> reverseEdges = this.reverseEdgeMap.get(e);
        ReverseEdge<V, E> reverseEdge = reverseEdges.remove(reverseEdges.size() - 1);
        ((DirectedEdgeGraph)this.reDigraph).removeEdge(reverseEdge);
        if (CollectionUtils.isEmpty(reverseEdges)) {
            this.reverseEdgeMap.remove(e);
        }
        return true;
    }

    @Override
    public Iterable<E> edges() {
        return ((DirectedEdgeGraph)this.digraph).edges();
    }

    @Override
    public void forEachEdges(Consumer<E> consumer) {
        ((DirectedEdgeGraph)this.digraph).forEachEdges((Consumer)consumer);
    }

    @Override
    public E reverseEdge(E e) {
        Objects.requireNonNull(e);
        if (!this.removeEdge(e)) {
            return null;
        }
        Object reverse = e.reverse();
        this.addEdge(reverse);
        return reverse;
    }

    @Override
    public DedirectedEdgeGraph<V, E> copy() {
        return new DedirectedEdgeGraph<V, E>(((DirectedEdgeGraph)this.digraph).copy(), ((DirectedEdgeGraph)this.reDigraph).copy());
    }

    @Override
    public DedirectedEdgeGraph<V, E> reverse() {
        if (this.edgeNum() == 0) {
            return new DedirectedEdgeGraph<V, E>();
        }
        ArrayList res = new ArrayList(this.edgeNum());
        ((DirectedEdgeGraph)this.digraph).forEachEdges((T edge) -> res.add(edge.reverse()));
        DedirectedEdgeGraph g = new DedirectedEdgeGraph(res);
        for (Object v : (DirectedEdgeGraph)this.digraph) {
            g.add(v);
        }
        return g;
    }

    @Override
    public Iterable<E> adjacent(Object v) {
        return new ComConcatItr(new Iterable[]{this.outAdjacent(v), this.inAdjacent(v)});
    }

    @Override
    public Iterable<E> inAdjacent(Object v) {
        return () -> new ReverseIterator(((DirectedEdgeGraph)this.reDigraph).adjacent(v).iterator());
    }

    @Override
    public Iterable<E> outAdjacent(Object v) {
        return new BiConcatIterable(((DirectedEdgeGraph)this.digraph).adjacent(v), Collections.emptyList());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DedirectedEdgeGraph that = (DedirectedEdgeGraph)o;
        return Objects.equals(this.reverseEdgeMap, that.reverseEdgeMap);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.reverseEdgeMap);
    }

    private void putEdgeMap(E edge, ReverseEdge<V, E> reverseEdge) {
        this.reverseEdgeMap.compute(edge, (k, v) -> {
            if (v == null) {
                v = new ArrayList<ReverseEdge>(1);
            }
            v.add(reverseEdge);
            return v;
        });
    }

    static class ReverseEdge<V, B extends DirectedEdge<V, B>>
    extends AbstractEdge<V, ReverseEdge<V, B>>
    implements DirectedEdge<V, ReverseEdge<V, B>>,
    Serializable {
        private static final long serialVersionUID = 4362288930468885917L;
        private final B edge;

        protected ReverseEdge(V from, V to, double weight, B edge) {
            super(from, to, weight);
            Objects.requireNonNull(edge);
            this.edge = edge;
        }

        @Override
        public V from() {
            return (V)this.left;
        }

        @Override
        public V to() {
            return (V)this.right;
        }

        @Override
        public ReverseEdge<V, B> reverse() {
            return new ReverseEdge(this.to(), this.from(), this.weight, this.edge.reverse());
        }

        @Override
        public ReverseEdge<V, B> copy() {
            return new ReverseEdge<V, B>(this.from(), this.to(), this.weight, this.edge);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ReverseEdge that = (ReverseEdge)o;
            return Objects.equals(this.edge, that.edge);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.edge);
        }
    }

    static class ReverseIterator<V, E extends DirectedEdge<V, E>>
    implements Iterator<E> {
        private final Iterator<ReverseEdge<V, E>> reverseEdgeIterator;

        private ReverseIterator(Iterator<ReverseEdge<V, E>> reverseEdgeIterator) {
            Objects.requireNonNull(reverseEdgeIterator);
            this.reverseEdgeIterator = reverseEdgeIterator;
        }

        @Override
        public boolean hasNext() {
            return this.reverseEdgeIterator.hasNext();
        }

        @Override
        public E next() {
            return (E)((ReverseEdge)this.reverseEdgeIterator.next()).edge;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Adjacent Iterator not support delete!");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReverseIterator that = (ReverseIterator)o;
            return Objects.equals(this.reverseEdgeIterator, that.reverseEdgeIterator);
        }

        public int hashCode() {
            return Objects.hash(this.reverseEdgeIterator);
        }
    }

    static class ComConcatItr<V, E extends DirectedEdge<V, E>>
    extends BiConcatIterable<E> {
        public ComConcatItr(Iterable<? extends E> ... iterables) {
            super(iterables);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof ComConcatItr)) {
                return false;
            }
            Iterator i1 = this.iterator();
            Iterator i2 = ((ComConcatItr)o).iterator();
            while (i1.hasNext() && i2.hasNext()) {
                if (Objects.equals(i1.next(), i2.next())) continue;
                return false;
            }
            return i1.hasNext() == i2.hasNext();
        }

        @Override
        public int hashCode() {
            int hashCode = 1;
            for (DirectedEdge e : this) {
                hashCode += e.hashCode();
            }
            return hashCode;
        }
    }
}

