/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.def;

import java.util.Collections;
import java.util.Objects;
import org.graphper.def.BiConcatIterable;
import org.graphper.def.DirectedGraph;
import org.graphper.def.ProxyDedigraph;
import org.graphper.def.VertexDedigraph;

public class DedirectedGraph<V>
extends ProxyDedigraph<V, DirectedGraph<V>, DirectedGraph<V>>
implements VertexDedigraph<V> {
    private static final long serialVersionUID = -7910958796521952954L;

    public DedirectedGraph() {
        this(new DirectedGraph(), new DirectedGraph());
    }

    public DedirectedGraph(int capacity) {
        this(new DirectedGraph(capacity), new DirectedGraph(capacity));
    }

    public DedirectedGraph(V[] vertices) {
        this(new DirectedGraph<V>(vertices), new DirectedGraph<V>(vertices));
    }

    private DedirectedGraph(DirectedGraph<V> digraph, DirectedGraph<V> reDigraph) {
        super(digraph, reDigraph);
    }

    @Override
    protected Iterable<V> inIte(Object v) {
        return ((DirectedGraph)this.reDigraph).adjacent(v);
    }

    @Override
    protected Iterable<V> outIte(Object v) {
        return ((DirectedGraph)this.digraph).adjacent(v);
    }

    @Override
    public DedirectedGraph<V> copy() {
        return new DedirectedGraph<V>(((DirectedGraph)this.digraph).copy(), ((DirectedGraph)this.reDigraph).copy());
    }

    @Override
    public DedirectedGraph<V> reverse() {
        return new DedirectedGraph<V>(((DirectedGraph)this.digraph).reverse(), ((DirectedGraph)this.reDigraph).reverse());
    }

    @Override
    public void addEdge(V v, V w) {
        if (Objects.isNull(v) || Objects.isNull(w)) {
            throw new NullPointerException();
        }
        ((DirectedGraph)this.digraph).addEdge(v, w);
        ((DirectedGraph)this.reDigraph).addEdge(w, v);
    }

    @Override
    public boolean removeEdge(Object v, Object w) {
        return ((DirectedGraph)this.digraph).removeEdge(v, w) && ((DirectedGraph)this.reDigraph).removeEdge(w, v);
    }

    @Override
    public Iterable<V> adjacent(Object v) {
        return new BiConcatIterable(this.outAdjacent(v), this.inAdjacent(v));
    }

    @Override
    public Iterable<V> inAdjacent(Object v) {
        return new BiConcatIterable(((DirectedGraph)this.reDigraph).adjacent(v), Collections.emptyList());
    }

    @Override
    public Iterable<V> outAdjacent(Object v) {
        return new BiConcatIterable(((DirectedGraph)this.digraph).adjacent(v), Collections.emptyList());
    }
}

