/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.def;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.graphper.def.AdjEdgeGraph;
import org.graphper.def.Digraph;
import org.graphper.def.DirectedEdge;
import org.graphper.def.VertexIndex;

public class DirectedEdgeGraph<V, E extends DirectedEdge<V, E>>
extends AdjEdgeGraph<V, E>
implements Digraph.EdgeDigraph<V, E> {
    private static final long serialVersionUID = 7489284046620730360L;

    public DirectedEdgeGraph() {
    }

    public DirectedEdgeGraph(int capacity) {
        super(capacity);
    }

    public DirectedEdgeGraph(E[] edges) {
        super(edges);
    }

    @Override
    public void addEdge(E edge) {
        Object target;
        AdjEdgeGraph.EdgeBag bagTarget;
        Objects.requireNonNull(edge, "Edge can not be null");
        Object source = edge.from();
        AdjEdgeGraph.EdgeBag bagSource = (AdjEdgeGraph.EdgeBag)this.adjacent(source);
        if (bagSource == AdjEdgeGraph.EdgeBag.EMPTY) {
            bagSource = this.addBag(source);
        }
        if ((bagTarget = (AdjEdgeGraph.EdgeBag)this.adjacent(target = edge.to())) == AdjEdgeGraph.EdgeBag.EMPTY) {
            bagTarget = this.addBag(target);
        }
        bagSource.add(edge);
        ++bagTarget.degree;
        if (bagSource == bagTarget) {
            ++bagSource.loopNum;
        }
        ++this.edgeNum;
    }

    @Override
    public boolean removeEdge(E e) {
        AdjEdgeGraph.EdgeBag bagTarget;
        if (this.vertexNum == 0 || this.edgeNum == 0 || e == null) {
            return false;
        }
        AdjEdgeGraph.EdgeBag bagSource = (AdjEdgeGraph.EdgeBag)this.adjacent(e.from());
        if (bagSource == AdjEdgeGraph.EdgeBag.EMPTY || (bagTarget = (AdjEdgeGraph.EdgeBag)this.adjacent(e.to())) == AdjEdgeGraph.EdgeBag.EMPTY) {
            return false;
        }
        if (!bagSource.remove(e)) {
            return false;
        }
        --bagTarget.degree;
        if (bagSource == bagTarget) {
            --bagSource.loopNum;
        }
        --this.edgeNum;
        return true;
    }

    @Override
    public boolean remove(Object vertex) {
        int index;
        AdjEdgeGraph.EdgeBag bag = null;
        if (vertex instanceof VertexIndex) {
            Integer i = ((VertexIndex)vertex).getGraphIndex().get(this.checkAndReturnGraphRef());
            if (i != null && i >= 0 && i < this.vertexNum && Objects.equals(this.bags[i.intValue()].vertex, vertex)) {
                index = i;
                bag = this.bags[index];
            }
        } else {
            for (index = 0; index < this.vertexNum; ++index) {
                bag = this.bags[index];
                if (Objects.equals(bag.vertex, vertex)) break;
            }
            if (index == this.vertexNum) {
                return false;
            }
        }
        if (bag == null) {
            return false;
        }
        int bagEdges = bag.degree - bag.loopNum;
        for (DirectedEdge e2 : bag) {
            AdjEdgeGraph.EdgeBag tBag = (AdjEdgeGraph.EdgeBag)this.adjacent(e2.other(bag.vertex));
            if (tBag == bag || tBag == AdjEdgeGraph.EdgeBag.EMPTY) continue;
            --tBag.degree;
        }
        if (index != this.vertexNum) {
            System.arraycopy(this.bags, index + 1, this.bags, index, this.vertexNum - index - 1);
        }
        int nv = --this.vertexNum;
        Object bagVertex = bag.vertex;
        for (int i = 0; i < nv; ++i) {
            if (this.bags[i].vertex instanceof VertexIndex) {
                ((VertexIndex)this.bags[i].vertex).getGraphIndex().put(this.checkAndReturnGraphRef(), i);
            }
            this.bags[i].removeIf(e -> Objects.equals(e.to(), bagVertex));
        }
        this.bags[nv] = null;
        this.edgeNum -= bagEdges;
        ++this.modCount;
        ++bag.bModCount;
        return true;
    }

    @Override
    public E reverseEdge(E edge) {
        Objects.requireNonNull(edge);
        AdjEdgeGraph.EdgeBag sBag = (AdjEdgeGraph.EdgeBag)this.adjacent(edge.from());
        if (sBag == AdjEdgeGraph.EdgeBag.EMPTY) {
            return null;
        }
        if (!sBag.remove(edge)) {
            return null;
        }
        AdjEdgeGraph.EdgeBag tBag = (AdjEdgeGraph.EdgeBag)this.adjacent(edge.to());
        Object reserveEdge = edge.reverse();
        tBag.add(reserveEdge);
        ++sBag.degree;
        --tBag.degree;
        return reserveEdge;
    }

    @Override
    public DirectedEdgeGraph<V, E> copy() {
        DirectedEdgeGraph<V, E> graph = new DirectedEdgeGraph<V, E>(this.bags.length);
        graph.bags = this.bagRepl();
        graph.vertexNum = this.vertexNum;
        graph.edgeNum = this.edgeNum;
        if (this.vertexNum > 0 && graph.bags[0].vertex instanceof VertexIndex) {
            VertexIndex.GraphRef gf = graph.checkAndReturnGraphRef();
            for (int i = 0; i < graph.vertexNum; ++i) {
                VertexIndex v = (VertexIndex)graph.bags[i].vertex;
                v.getGraphIndex().put(gf, v.index(this.checkAndReturnGraphRef()));
            }
        }
        return graph;
    }

    @Override
    public DirectedEdgeGraph<V, E> reverse() {
        DirectedEdgeGraph digraph = new DirectedEdgeGraph();
        for (int i = 0; i < this.vertexNum; ++i) {
            AdjEdgeGraph.EdgeBag bag = this.bags[i];
            Object v = bag.vertex;
            for (DirectedEdge e : this.adjacent(v)) {
                Object re = e.reverse();
                digraph.addEdge(re);
            }
            digraph.add(v);
        }
        return digraph;
    }

    @Override
    public Iterator<V> iterator() {
        return new DirectionEdgeIterator();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && this.getClass() == o.getClass();
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.getClass().hashCode();
    }

    private class DirectionEdgeIterator
    extends AdjEdgeGraph.AdjIterator {
        private DirectionEdgeIterator() {
        }

        @Override
        public void remove() {
            this.checkIsConcurrentModify();
            if (this.index == 0) {
                throw new IllegalStateException();
            }
            AdjEdgeGraph.EdgeBag bag = DirectedEdgeGraph.this.bags[this.index - 1];
            if (bag == null) {
                throw new NoSuchElementException();
            }
            int bagEdges = bag.degree - bag.loopNum;
            for (DirectedEdge e2 : bag) {
                AdjEdgeGraph.EdgeBag tBag = (AdjEdgeGraph.EdgeBag)DirectedEdgeGraph.this.adjacent(e2.other(bag.vertex));
                if (tBag == bag || tBag == AdjEdgeGraph.EdgeBag.EMPTY) continue;
                --tBag.degree;
            }
            if (this.index != DirectedEdgeGraph.this.vertexNum) {
                System.arraycopy(DirectedEdgeGraph.this.bags, this.index, DirectedEdgeGraph.this.bags, this.index - 1, DirectedEdgeGraph.this.vertexNum - this.index);
            }
            int nv = --DirectedEdgeGraph.this.vertexNum;
            Object bagVertex = bag.vertex;
            for (int i = 0; i < nv; ++i) {
                if (DirectedEdgeGraph.this.bags[i].vertex instanceof VertexIndex) {
                    ((VertexIndex)DirectedEdgeGraph.this.bags[i].vertex).getGraphIndex().put(DirectedEdgeGraph.this.checkAndReturnGraphRef(), i);
                }
                DirectedEdgeGraph.this.bags[i].removeIf(e -> Objects.equals(e.to(), bagVertex));
            }
            DirectedEdgeGraph.this.bags[nv] = null;
            --this.index;
            ++this.exceptModCount;
            ++DirectedEdgeGraph.this.modCount;
            DirectedEdgeGraph.this.edgeNum -= bagEdges;
        }
    }
}

