/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.def;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.graphper.def.AdjVertexGraph;
import org.graphper.def.Digraph;
import org.graphper.def.VertexIndex;

public class DirectedGraph<V>
extends AdjVertexGraph<V>
implements Digraph.VertexDigraph<V> {
    private static final long serialVersionUID = 1062819133746040326L;

    public DirectedGraph() {
    }

    public DirectedGraph(int capacity) {
        super(capacity);
    }

    public DirectedGraph(V[] vertices) {
        super(vertices);
    }

    @Override
    public void addEdge(V source, V target) {
        AdjVertexGraph.VertexBag<V> bagTarget;
        if (source == null || target == null) {
            throw new NullPointerException();
        }
        AdjVertexGraph.VertexBag<V> bagSource = (AdjVertexGraph.VertexBag<V>)this.adjacent(source);
        if (bagSource == AdjVertexGraph.VertexBag.EMPTY) {
            bagSource = this.addBag(source);
        }
        if ((bagTarget = (AdjVertexGraph.VertexBag<V>)this.adjacent(target)) == AdjVertexGraph.VertexBag.EMPTY) {
            bagTarget = this.addBag(target);
        }
        bagSource.add(target);
        ++bagTarget.degree;
        if (bagSource == bagTarget) {
            ++bagSource.loopNum;
        }
        ++this.edgeNum;
    }

    @Override
    public boolean removeEdge(Object source, Object target) {
        AdjVertexGraph.VertexBag bagTarget;
        AdjVertexGraph.VertexBag bagSource = (AdjVertexGraph.VertexBag)this.adjacent(source);
        if (bagSource == AdjVertexGraph.VertexBag.EMPTY || (bagTarget = (AdjVertexGraph.VertexBag)this.adjacent(target)) == AdjVertexGraph.VertexBag.EMPTY) {
            return false;
        }
        if (!bagSource.remove(target)) {
            return false;
        }
        --bagTarget.degree;
        if (bagSource == bagTarget) {
            --bagSource.loopNum;
        }
        --this.edgeNum;
        return true;
    }

    @Override
    public boolean remove(Object vertex) {
        int index;
        AdjVertexGraph.VertexBag bag = null;
        if (vertex instanceof VertexIndex) {
            Integer i = ((VertexIndex)vertex).getGraphIndex().get(this.checkAndReturnGraphRef());
            if (i != null && i >= 0 && i < this.vertexNum && Objects.equals(this.bags[i.intValue()].vertex, vertex)) {
                index = i;
                bag = this.bags[index];
            }
        } else {
            for (index = 0; index < this.vertexNum; ++index) {
                bag = this.bags[index];
                if (Objects.equals(bag.vertex, vertex)) break;
            }
            if (index == this.vertexNum) {
                return false;
            }
        }
        if (bag == null) {
            return false;
        }
        int bagEdges = bag.degree - bag.loopNum;
        for (Object v : bag) {
            AdjVertexGraph.VertexBag tBag = (AdjVertexGraph.VertexBag)this.adjacent(v);
            if (tBag == bag || tBag == AdjVertexGraph.VertexBag.EMPTY) continue;
            --tBag.degree;
        }
        if (index != this.vertexNum) {
            System.arraycopy(this.bags, index + 1, this.bags, index, this.vertexNum - index - 1);
        }
        int nv = --this.vertexNum;
        for (int i = 0; i < nv; ++i) {
            if (this.bags[i].vertex instanceof VertexIndex) {
                ((VertexIndex)this.bags[i].vertex).getGraphIndex().put(this.checkAndReturnGraphRef(), i);
            }
            this.bags[i].remove(bag.vertex);
        }
        this.bags[nv] = null;
        this.edgeNum -= bagEdges;
        ++this.modCount;
        ++bag.bModCount;
        return true;
    }

    @Override
    public DirectedGraph<V> copy() {
        DirectedGraph<V> directedGraph = new DirectedGraph<V>(this.bags.length);
        directedGraph.bags = this.bagRepl();
        directedGraph.vertexNum = this.vertexNum;
        directedGraph.edgeNum = this.edgeNum;
        if (this.vertexNum > 0 && directedGraph.bags[0].vertex instanceof VertexIndex) {
            VertexIndex.GraphRef gf = directedGraph.checkAndReturnGraphRef();
            for (int i = 0; i < directedGraph.vertexNum; ++i) {
                VertexIndex v = (VertexIndex)directedGraph.bags[i].vertex;
                v.getGraphIndex().put(gf, v.index(this.checkAndReturnGraphRef()));
            }
        }
        return directedGraph;
    }

    @Override
    public DirectedGraph<V> reverse() {
        DirectedGraph<Object> digraph = new DirectedGraph<Object>(this.toArray());
        for (int i = 0; i < this.vertexNum; ++i) {
            AdjVertexGraph.VertexBag bag = this.bags[i];
            Object v = bag.vertex;
            for (Object w : bag) {
                digraph.addEdge(w, v);
            }
            digraph.add(v);
        }
        return digraph;
    }

    @Override
    public Iterator<V> iterator() {
        return new DirectionIterator();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && this.getClass() == o.getClass();
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.getClass().hashCode();
    }

    @Override
    public String toString() {
        StringBuilder print = new StringBuilder("vertices " + this.vertexNum() + ", edges:\n");
        for (V v : this) {
            print.append("[").append(v).append("] ");
            for (Object n : this.adjacent(v)) {
                print.append(v).append("->").append(n).append(" ");
            }
            print.append("\n");
        }
        return print.toString();
    }

    private class DirectionIterator
    extends AdjVertexGraph.AdjIterator {
        private DirectionIterator() {
        }

        @Override
        public void remove() {
            this.checkIsConcurrentModify();
            if (this.index == 0) {
                throw new IllegalStateException();
            }
            AdjVertexGraph.VertexBag bag = DirectedGraph.this.bags[this.index - 1];
            if (bag == null) {
                throw new NoSuchElementException();
            }
            int bagEdges = bag.degree - bag.loopNum;
            for (Object v : bag) {
                AdjVertexGraph.VertexBag tBag = (AdjVertexGraph.VertexBag)DirectedGraph.this.adjacent(v);
                if (tBag == bag || tBag == AdjVertexGraph.VertexBag.EMPTY) continue;
                --tBag.degree;
            }
            if (this.index != DirectedGraph.this.vertexNum) {
                System.arraycopy(DirectedGraph.this.bags, this.index, DirectedGraph.this.bags, this.index - 1, DirectedGraph.this.vertexNum - this.index);
            }
            int nv = --DirectedGraph.this.vertexNum;
            for (int i = 0; i < nv; ++i) {
                if (DirectedGraph.this.bags[i].vertex instanceof VertexIndex) {
                    ((VertexIndex)DirectedGraph.this.bags[i].vertex).getGraphIndex().put(DirectedGraph.this.checkAndReturnGraphRef(), i);
                }
                DirectedGraph.this.bags[i].remove(bag.vertex);
            }
            DirectedGraph.this.bags[nv] = null;
            --this.index;
            ++this.exceptModCount;
            ++DirectedGraph.this.modCount;
            DirectedGraph.this.edgeNum -= bagEdges;
        }
    }
}

