/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.def;

import java.io.Serializable;
import java.util.Objects;
import org.graphper.def.UnmodifiablePointException;
import org.graphper.def.Vectors;

public class FlatPoint
implements Comparable<FlatPoint>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -8316004807717552046L;
    private double x;
    private double y;

    public FlatPoint(double height, double width) {
        this.x = height;
        this.y = width;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.getY();
    }

    public double getHeight() {
        return this.getX();
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setHeight(double height) {
        this.setX(height);
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setWidth(double width) {
        this.setY(width);
    }

    public FlatPoint reserve() {
        return new FlatPoint(-this.x, -this.y);
    }

    public double dist() {
        return Vectors.len(this.x, this.y);
    }

    public boolean similarX(double x, double error) {
        return Math.abs(this.x - x) <= error;
    }

    public boolean similarY(double y, double error) {
        return Math.abs(this.y - y) <= error;
    }

    public void flip() {
        double tmp = this.x;
        this.x = this.y;
        this.y = tmp;
    }

    public static double twoFlatPointDistance(FlatPoint p1, FlatPoint p2) {
        Objects.requireNonNull(p1);
        Objects.requireNonNull(p2);
        return FlatPoint.twoPointDistance(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public static double twoPointDistance(double p1x, double p1y, double p2x, double p2y) {
        if (p1x == p2x) {
            return Math.abs(p2y - p1y);
        }
        if (p1y == p2y) {
            return Math.abs(p2x - p1x);
        }
        return Math.sqrt(Math.pow(p2y - p1y, 2.0) + Math.pow(p2x - p1x, 2.0));
    }

    @Override
    public int compareTo(FlatPoint o) {
        if (o == null) {
            return 1;
        }
        int r = Double.compare(this.x, o.x);
        if (r != 0) {
            return r;
        }
        return Double.compare(this.y, o.y);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlatPoint flatPoint = (FlatPoint)o;
        return Double.compare(flatPoint.x, this.x) == 0 && Double.compare(flatPoint.y, this.y) == 0;
    }

    public FlatPoint clone() {
        try {
            return (FlatPoint)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return new FlatPoint(this.x, this.y);
        }
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }

    public String toString() {
        return "FlatPoint{x=" + this.x + ", y=" + this.y + '}';
    }

    public static class UnmodifyFlatPoint
    extends FlatPoint {
        private static final long serialVersionUID = -6758408197504503804L;
        private static final String UN_MODIFY_ERROR = "The current FlatPoint cannot be modified.";

        public UnmodifyFlatPoint(double height, double width) {
            super(height, width);
        }

        @Override
        public void setX(double x) {
            throw new UnmodifiablePointException(UN_MODIFY_ERROR);
        }

        @Override
        public void setHeight(double height) {
            throw new UnmodifiablePointException(UN_MODIFY_ERROR);
        }

        @Override
        public void setY(double y) {
            throw new UnmodifiablePointException(UN_MODIFY_ERROR);
        }

        @Override
        public void setWidth(double width) {
            throw new UnmodifiablePointException(UN_MODIFY_ERROR);
        }

        @Override
        public void flip() {
            throw new UnmodifiablePointException(UN_MODIFY_ERROR);
        }
    }
}

