/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.def;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Objects;
import org.graphper.def.AbstractBaseGraph;
import org.graphper.def.Dedigraph;
import org.graphper.def.Digraph;

abstract class ProxyDedigraph<V, D extends Digraph<V>, R extends Digraph<V>>
extends AbstractBaseGraph<V>
implements Dedigraph<V>,
Serializable {
    private static final long serialVersionUID = 5269319670434302102L;
    protected final D digraph;
    protected final R reDigraph;

    protected ProxyDedigraph(D digraph, R reDigraph) {
        Objects.requireNonNull(digraph);
        Objects.requireNonNull(reDigraph);
        this.digraph = digraph;
        this.reDigraph = reDigraph;
    }

    @Override
    public int vertexNum() {
        return this.digraph.vertexNum();
    }

    @Override
    public int edgeNum() {
        return this.digraph.edgeNum();
    }

    @Override
    public boolean add(V v) {
        return this.digraph.add(v) && this.reDigraph.add(v);
    }

    @Override
    public boolean remove(Object v) {
        return this.digraph.remove(v) && this.reDigraph.remove(v);
    }

    @Override
    public int degree(V v) {
        return this.digraph.degree(v);
    }

    @Override
    public int inDegree(V v) {
        int count = 0;
        for (Object ignore : this.inIte(v)) {
            ++count;
        }
        return count;
    }

    @Override
    public int outDegree(V v) {
        int count = 0;
        for (Object ignore : this.outIte(v)) {
            ++count;
        }
        return count;
    }

    @Override
    public int numberOfLoops() {
        return this.digraph.numberOfLoops();
    }

    @Override
    public int selfLoops(V v) {
        return this.digraph.selfLoops(v);
    }

    @Override
    public V[] toArray() {
        return this.digraph.toArray();
    }

    @Override
    public void clear() {
        this.digraph.clear();
        this.reDigraph.clear();
    }

    @Override
    public Iterator<V> iterator() {
        return new ProxyIterator((Digraph)this.digraph, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProxyDedigraph that = (ProxyDedigraph)o;
        return Objects.equals(this.digraph, that.digraph) && Objects.equals(this.reDigraph, that.reDigraph);
    }

    public int hashCode() {
        return Objects.hash(this.digraph, this.reDigraph);
    }

    public String toString() {
        return this.digraph.toString();
    }

    protected abstract <T> Iterable<T> inIte(Object var1);

    protected abstract <T> Iterable<T> outIte(Object var1);

    private static class ProxyIterator<V, D extends Digraph<V>>
    implements Iterator<V> {
        private final Iterator<V> iterator;

        private ProxyIterator(D digraph) {
            Objects.requireNonNull(digraph);
            this.iterator = digraph.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public V next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("ProxyDedigraph's vertex cannot be deleted by iterator");
        }

        /* synthetic */ ProxyIterator(Digraph x0, 1 x1) {
            this(x0);
        }
    }
}

