/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.def;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.graphper.def.AdjEdgeGraph;
import org.graphper.def.Edge;
import org.graphper.def.Graph;
import org.graphper.def.VertexIndex;

public class UndirectedEdgeGraph<V, E extends Edge<V, E>>
extends AdjEdgeGraph<V, E>
implements Graph.EdgeGraph<V, E> {
    private static final long serialVersionUID = -3215868703245301095L;

    public UndirectedEdgeGraph() {
    }

    public UndirectedEdgeGraph(int capacity) {
        super(capacity);
    }

    public UndirectedEdgeGraph(E[] edges) {
        super(edges);
    }

    @Override
    public void addEdge(E e) {
        Object w;
        AdjEdgeGraph.EdgeBag bagW;
        Objects.requireNonNull(e);
        Object v = e.either();
        AdjEdgeGraph.EdgeBag bagV = (AdjEdgeGraph.EdgeBag)this.adjacent(v);
        if (bagV == AdjEdgeGraph.EdgeBag.EMPTY) {
            bagV = this.addBag(v);
        }
        if ((bagW = (AdjEdgeGraph.EdgeBag)this.adjacent(w = e.other(v))) == AdjEdgeGraph.EdgeBag.EMPTY) {
            bagW = this.addBag(w);
        }
        bagV.add(e);
        bagW.add(e);
        if (bagV == bagW) {
            ++bagV.loopNum;
        }
        ++this.edgeNum;
    }

    @Override
    public boolean removeEdge(E edge) {
        AdjEdgeGraph.EdgeBag bagW;
        if (this.vertexNum == 0 || this.edgeNum == 0 || edge == null) {
            return false;
        }
        AdjEdgeGraph.EdgeBag bagV = (AdjEdgeGraph.EdgeBag)this.adjacent(edge.either());
        if (bagV == AdjEdgeGraph.EdgeBag.EMPTY || (bagW = (AdjEdgeGraph.EdgeBag)this.adjacent(edge.other(edge.either()))) == AdjEdgeGraph.EdgeBag.EMPTY) {
            return false;
        }
        if (!bagV.remove(edge) || !bagW.remove(edge)) {
            return false;
        }
        if (bagV == bagW) {
            --bagV.loopNum;
        }
        --this.edgeNum;
        return true;
    }

    @Override
    public boolean remove(Object vertex) {
        int index;
        AdjEdgeGraph.EdgeBag bag = null;
        if (vertex instanceof VertexIndex) {
            Integer i = ((VertexIndex)vertex).getGraphIndex().get(this.checkAndReturnGraphRef());
            if (i != null && i >= 0 && i < this.vertexNum && Objects.equals(this.bags[i.intValue()].vertex, vertex)) {
                index = i;
                bag = this.bags[index];
            }
        } else {
            for (index = 0; index < this.vertexNum; ++index) {
                bag = this.bags[index];
                if (Objects.equals(bag.vertex, vertex)) break;
            }
            if (index == this.vertexNum) {
                return false;
            }
        }
        if (bag == null) {
            return false;
        }
        int bagEdges = bag.degree - bag.loopNum;
        for (Edge e : bag) {
            AdjEdgeGraph.EdgeBag tBag = (AdjEdgeGraph.EdgeBag)this.adjacent(e.other(bag.vertex));
            if (bag == tBag || tBag == AdjEdgeGraph.EdgeBag.EMPTY) continue;
            tBag.remove(e);
        }
        if (index != this.vertexNum) {
            System.arraycopy(this.bags, index + 1, this.bags, index, this.vertexNum - index - 1);
        }
        int nv = --this.vertexNum;
        if (bag.vertex instanceof VertexIndex) {
            for (int i = index; i < nv; ++i) {
                ((VertexIndex)this.bags[i].vertex).getGraphIndex().computeIfPresent(this.checkAndReturnGraphRef(), (k, v) -> v - 1);
            }
        }
        this.bags[nv] = null;
        this.edgeNum -= bagEdges;
        ++this.modCount;
        ++bag.bModCount;
        return true;
    }

    @Override
    public UndirectedEdgeGraph<V, E> copy() {
        UndirectedEdgeGraph<V, E> graph = new UndirectedEdgeGraph<V, E>(this.bags.length);
        graph.bags = this.bagRepl();
        graph.vertexNum = this.vertexNum;
        graph.edgeNum = this.edgeNum;
        if (this.vertexNum > 0 && graph.bags[0].vertex instanceof VertexIndex) {
            VertexIndex.GraphRef gf = graph.checkAndReturnGraphRef();
            for (int i = 0; i < graph.vertexNum; ++i) {
                VertexIndex v = (VertexIndex)graph.bags[i].vertex;
                v.getGraphIndex().put(gf, v.index(this.checkAndReturnGraphRef()));
            }
        }
        return graph;
    }

    @Override
    public Iterator<V> iterator() {
        return new UndirectedEdgeIterator();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && this.getClass() == o.getClass();
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.getClass().hashCode();
    }

    private class UndirectedEdgeIterator
    extends AdjEdgeGraph.AdjIterator {
        private UndirectedEdgeIterator() {
        }

        @Override
        public void remove() {
            this.checkIsConcurrentModify();
            if (this.index == 0) {
                throw new IllegalStateException();
            }
            AdjEdgeGraph.EdgeBag bag = UndirectedEdgeGraph.this.bags[this.index - 1];
            if (bag == null) {
                throw new NoSuchElementException();
            }
            int bagEdges = bag.degree - bag.loopNum;
            for (Edge e : bag) {
                AdjEdgeGraph.EdgeBag tBag = (AdjEdgeGraph.EdgeBag)UndirectedEdgeGraph.this.adjacent(e.other(bag.vertex));
                if (tBag == bag || tBag == AdjEdgeGraph.EdgeBag.EMPTY) continue;
                tBag.remove(e);
            }
            if (this.index != UndirectedEdgeGraph.this.vertexNum) {
                System.arraycopy(UndirectedEdgeGraph.this.bags, this.index, UndirectedEdgeGraph.this.bags, this.index - 1, UndirectedEdgeGraph.this.vertexNum - this.index);
            }
            int nv = --UndirectedEdgeGraph.this.vertexNum;
            --this.index;
            if (bag.vertex instanceof VertexIndex) {
                for (int i = this.index; i < nv; ++i) {
                    ((VertexIndex)UndirectedEdgeGraph.this.bags[i].vertex).getGraphIndex().computeIfPresent(UndirectedEdgeGraph.this.checkAndReturnGraphRef(), (k, v) -> v - 1);
                }
            }
            UndirectedEdgeGraph.this.bags[nv] = null;
            ++this.exceptModCount;
            ++UndirectedEdgeGraph.this.modCount;
            UndirectedEdgeGraph.this.edgeNum -= bagEdges;
        }
    }
}

