/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.def;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.graphper.def.AdjVertexGraph;
import org.graphper.def.Graph;
import org.graphper.def.VertexIndex;

public class UndirectedGraph<V>
extends AdjVertexGraph<V>
implements Graph.VertexGraph<V> {
    private static final long serialVersionUID = -1768121664171529422L;

    public UndirectedGraph() {
    }

    public UndirectedGraph(int capacity) {
        super(capacity);
    }

    public UndirectedGraph(V[] vertices) {
        super(vertices);
    }

    @Override
    public void addEdge(V v, V w) {
        AdjVertexGraph.VertexBag<V> bagW;
        if (v == null || w == null) {
            throw new NullPointerException();
        }
        AdjVertexGraph.VertexBag<V> bagV = (AdjVertexGraph.VertexBag<V>)this.adjacent(v);
        if (bagV == AdjVertexGraph.VertexBag.EMPTY) {
            bagV = this.addBag(v);
        }
        if ((bagW = (AdjVertexGraph.VertexBag<V>)this.adjacent(w)) == AdjVertexGraph.VertexBag.EMPTY) {
            bagW = this.addBag(w);
        }
        bagV.add(w);
        bagW.add(v);
        if (bagV == bagW) {
            ++bagV.loopNum;
        }
        ++this.edgeNum;
    }

    @Override
    public boolean removeEdge(Object v, Object w) {
        AdjVertexGraph.VertexBag bagW;
        AdjVertexGraph.VertexBag bagV = (AdjVertexGraph.VertexBag)this.adjacent(v);
        if (bagV == AdjVertexGraph.VertexBag.EMPTY || (bagW = (AdjVertexGraph.VertexBag)this.adjacent(w)) == AdjVertexGraph.VertexBag.EMPTY) {
            return false;
        }
        if (!bagV.remove(w) || !bagW.remove(v)) {
            return false;
        }
        if (bagV == bagW) {
            --bagV.loopNum;
        }
        --this.edgeNum;
        return true;
    }

    @Override
    public boolean remove(Object vertex) {
        int index;
        AdjVertexGraph.VertexBag bag = null;
        if (vertex instanceof VertexIndex) {
            Integer i = ((VertexIndex)vertex).getGraphIndex().get(this.checkAndReturnGraphRef());
            if (i != null && i >= 0 && i < this.vertexNum && Objects.equals(this.bags[i.intValue()].vertex, vertex)) {
                index = i;
                bag = this.bags[index];
            }
        } else {
            for (index = 0; index < this.vertexNum; ++index) {
                bag = this.bags[index];
                if (Objects.equals(bag.vertex, vertex)) break;
            }
            if (index == this.vertexNum) {
                return false;
            }
        }
        if (bag == null) {
            return false;
        }
        int bagEdges = bag.degree - bag.loopNum;
        for (Object v2 : bag) {
            AdjVertexGraph.VertexBag tBag = (AdjVertexGraph.VertexBag)this.adjacent(v2);
            if (bag == tBag || tBag == AdjVertexGraph.VertexBag.EMPTY) continue;
            tBag.remove(bag.vertex);
        }
        if (index != this.vertexNum) {
            System.arraycopy(this.bags, index + 1, this.bags, index, this.vertexNum - index - 1);
        }
        int nv = --this.vertexNum;
        if (bag.vertex instanceof VertexIndex) {
            for (int i = index; i < nv; ++i) {
                ((VertexIndex)this.bags[i].vertex).getGraphIndex().computeIfPresent(this.checkAndReturnGraphRef(), (k, v) -> v - 1);
            }
        }
        this.bags[nv] = null;
        this.edgeNum -= bagEdges;
        ++this.modCount;
        ++bag.bModCount;
        return true;
    }

    @Override
    public UndirectedGraph<V> copy() {
        UndirectedGraph<V> undirectedGraph = new UndirectedGraph<V>(this.bags.length);
        undirectedGraph.bags = this.bagRepl();
        undirectedGraph.vertexNum = this.vertexNum;
        undirectedGraph.edgeNum = this.edgeNum;
        if (this.vertexNum > 0 && undirectedGraph.bags[0].vertex instanceof VertexIndex) {
            VertexIndex.GraphRef gf = undirectedGraph.checkAndReturnGraphRef();
            for (int i = 0; i < undirectedGraph.vertexNum; ++i) {
                VertexIndex v = (VertexIndex)undirectedGraph.bags[i].vertex;
                v.getGraphIndex().put(gf, v.index(this.checkAndReturnGraphRef()));
            }
        }
        return undirectedGraph;
    }

    @Override
    public Iterator<V> iterator() {
        return new UndirectionIterator();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && this.getClass() == o.getClass();
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.getClass().hashCode();
    }

    private class UndirectionIterator
    extends AdjVertexGraph.AdjIterator {
        private UndirectionIterator() {
        }

        @Override
        public void remove() {
            this.checkIsConcurrentModify();
            if (this.index == 0) {
                throw new IllegalStateException();
            }
            AdjVertexGraph.VertexBag bag = UndirectedGraph.this.bags[this.index - 1];
            if (bag == null) {
                throw new NoSuchElementException();
            }
            int bagEdges = bag.degree - bag.loopNum;
            for (Object v2 : bag) {
                AdjVertexGraph.VertexBag tBag = (AdjVertexGraph.VertexBag)UndirectedGraph.this.adjacent(v2);
                if (tBag == bag || tBag == AdjVertexGraph.VertexBag.EMPTY) continue;
                tBag.remove(bag.vertex);
            }
            if (this.index != UndirectedGraph.this.vertexNum) {
                System.arraycopy(UndirectedGraph.this.bags, this.index, UndirectedGraph.this.bags, this.index - 1, UndirectedGraph.this.vertexNum - this.index);
            }
            int nv = --UndirectedGraph.this.vertexNum;
            --this.index;
            if (bag.vertex instanceof VertexIndex) {
                for (int i = this.index; i < nv; ++i) {
                    ((VertexIndex)UndirectedGraph.this.bags[i].vertex).getGraphIndex().computeIfPresent(UndirectedGraph.this.checkAndReturnGraphRef(), (k, v) -> v - 1);
                }
            }
            UndirectedGraph.this.bags[nv] = null;
            ++this.exceptModCount;
            ++UndirectedGraph.this.modCount;
            UndirectedGraph.this.edgeNum -= bagEdges;
        }
    }
}

