/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.def;

import java.util.Objects;
import org.graphper.def.FlatPoint;
import org.graphper.def.UnfeasibleException;
import org.graphper.util.Asserts;
import org.graphper.util.ValueUtils;

public class Vectors {
    public static final FlatPoint ZERO = new FlatPoint.UnmodifyFlatPoint(0.0, 0.0);

    private Vectors() {
    }

    public static FlatPoint unit(double x, double y) {
        double len = Vectors.len(x, y);
        if (len != 0.0) {
            return new FlatPoint(x / len, y / len);
        }
        return new FlatPoint(0.0, 0.0);
    }

    public static FlatPoint unit(FlatPoint subtrahend, FlatPoint minuend) {
        Asserts.nullArgument(subtrahend, "subtrahend");
        Asserts.nullArgument(minuend, "minuend");
        double x = subtrahend.getX() - minuend.getX();
        double y = subtrahend.getY() - minuend.getY();
        return Vectors.unit(x, y);
    }

    public static FlatPoint sub(FlatPoint subtrahend, FlatPoint minuend) {
        Asserts.nullArgument(subtrahend, "subtrahend");
        Asserts.nullArgument(minuend, "minuend");
        return new FlatPoint(subtrahend.getX() - minuend.getX(), subtrahend.getY() - minuend.getY());
    }

    public static FlatPoint add(FlatPoint added, FlatPoint summand) {
        Asserts.nullArgument(added, "added");
        Asserts.nullArgument(summand, "summand");
        return new FlatPoint(added.getX() + summand.getX(), added.getY() + summand.getY());
    }

    public static double mul(FlatPoint multiplier, FlatPoint multiplicand) {
        Asserts.nullArgument(multiplier, "multiplier");
        Asserts.nullArgument(multiplicand, "multiplicand");
        return multiplier.getX() * multiplicand.getX() + multiplier.getY() * multiplicand.getY();
    }

    public static FlatPoint scale(FlatPoint vector, double newLen) {
        Asserts.nullArgument(vector, "vector");
        double len = Vectors.len(vector.getX(), vector.getY());
        if (len != 0.0) {
            return new FlatPoint(vector.getX() * newLen / len, vector.getY() * newLen / len);
        }
        return new FlatPoint(0.0, 0.0);
    }

    public static FlatPoint multiple(FlatPoint vector, double multiple) {
        Asserts.nullArgument(vector, "vector");
        return new FlatPoint(vector.getX() * multiple, vector.getY() * multiple);
    }

    public static double linerFuncGetX(FlatPoint p1, FlatPoint p2, double y) {
        Asserts.nullArgument(p1, "p1");
        Asserts.nullArgument(p2, "p2");
        return Vectors.linerFuncGetX(p1.getX(), p1.getY(), p2.getX(), p2.getY(), y);
    }

    public static double linerFuncGetX(double startX, double startY, double endX, double endY, double y) {
        Asserts.illegalArgument(startY == endY, "There are countless solutions to linear equations");
        if (startX == endX) {
            return startX;
        }
        double slope = (endY - startY) / (endX - startX);
        double constant = startY - startX * slope;
        return (y - constant) / slope;
    }

    public static double linerFuncGetY(FlatPoint p1, FlatPoint p2, double x) {
        Asserts.nullArgument(p1, "p1");
        Asserts.nullArgument(p2, "p2");
        return Vectors.linerFuncGetY(p1.getX(), p1.getY(), p2.getX(), p2.getY(), x);
    }

    public static double linerFuncGetY(double startX, double startY, double endX, double endY, double x) {
        Asserts.illegalArgument(startX == endX, "There are countless solutions to linear equations");
        if (startY == endY) {
            return startY;
        }
        double slope = (endY - startY) / (endX - startX);
        double constant = startY - startX * slope;
        return slope * x + constant;
    }

    public static FlatPoint lineInters(FlatPoint line1P1, FlatPoint line1P2, FlatPoint line2P1, FlatPoint line2P2) throws UnfeasibleException {
        Asserts.illegalArgument(line1P1 == null || line1P2 == null || line2P1 == null || line2P2 == null, "The line segment description is incomplete and there are null points");
        Asserts.illegalArgument(Objects.equals(line1P1, line1P2) || Objects.equals(line2P1, line2P2), "Two points must form a line segment");
        double m1 = line1P1.getX() - line1P2.getX();
        double d1 = line1P1.getY() - line1P2.getY();
        double m2 = line2P1.getX() - line2P2.getX();
        double d2 = line2P1.getY() - line2P2.getY();
        if (m1 == 0.0 && m2 == 0.0 || d1 == 0.0 && d2 == 0.0) {
            throw new UnfeasibleException("No intersection between two line segments");
        }
        if (ValueUtils.approximate(m1, 0.0, 0.001)) {
            return new FlatPoint(line1P1.getX(), Vectors.linerFuncGetY(line2P1, line2P2, line1P1.getX()));
        }
        if (ValueUtils.approximate(m2, 0.0, 0.001)) {
            return new FlatPoint(line2P1.getX(), Vectors.linerFuncGetY(line1P1, line1P2, line2P1.getX()));
        }
        if (ValueUtils.approximate(d1, 0.0, 0.001)) {
            return new FlatPoint(Vectors.linerFuncGetX(line2P1, line2P2, line1P1.getY()), line1P1.getY());
        }
        if (ValueUtils.approximate(d2, 0.0, 0.001)) {
            return new FlatPoint(Vectors.linerFuncGetX(line1P1, line1P2, line2P1.getY()), line2P1.getY());
        }
        double slope1 = d1 / m1;
        double slope2 = d2 / m2;
        if (ValueUtils.approximate(slope1, slope2, 0.001)) {
            throw new UnfeasibleException("No intersection between two line segments");
        }
        double constant1 = line1P1.getY() - line1P1.getX() * slope1;
        double constant2 = line2P1.getY() - line2P1.getX() * slope2;
        double x = (constant1 - constant2) / (slope2 - slope1);
        return new FlatPoint(x, slope1 * x + constant1);
    }

    public static boolean inAngle(FlatPoint corner, FlatPoint p1, FlatPoint p2, FlatPoint target) {
        Asserts.nullArgument(corner, "corner");
        Asserts.nullArgument(p1, "edge vector point of corner");
        Asserts.nullArgument(p2, "edge vector point of corner");
        Asserts.nullArgument(target, "target");
        return Vectors.inAngle(corner.getX(), corner.getY(), p1.getX(), p1.getY(), p2.getX(), p2.getY(), target.getX(), target.getY());
    }

    public static boolean inAngle(double cornerX, double cornerY, double p1x, double p1y, double p2x, double p2y, double testX, double testY) {
        return Vectors.onLineDown(cornerX, cornerY, p1x, p1y, testX, testY) == Vectors.onLineDown(cornerX, cornerY, p1x, p1y, p2x, p2y) && Vectors.onLineDown(cornerX, cornerY, p2x, p2y, testX, testY) == Vectors.onLineDown(cornerX, cornerY, p2x, p2y, p1x, p1y);
    }

    public static double squaredLen(double x, double y) {
        return x * x + y * y;
    }

    public static double len(double x, double y) {
        return Math.sqrt(Vectors.squaredLen(x, y));
    }

    private static boolean onLineDown(double startX, double startY, double endX, double endY, double targetX, double targetY) {
        if (startX == endX && startY == endY) {
            return false;
        }
        if (startX == endX) {
            return targetX > startX;
        }
        if (startY == endY) {
            return targetY < endY;
        }
        double val = Vectors.linerFuncGetY(startX, startY, endX, endY, targetX);
        return val > targetY && !ValueUtils.approximate(val, targetY, 0.01);
    }
}

