/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.draw;

import java.util.List;
import java.util.function.Function;
import org.graphper.draw.Brush;
import org.graphper.draw.DrawGraph;
import org.graphper.draw.Editor;
import org.graphper.util.Asserts;

public abstract class AbstractPipelineTrigger<I, B extends Brush, T extends Editor<I, B>, S extends AbstractPipelineTrigger<I, B, T, S>> {
    protected final List<T> editors;
    protected final DrawGraph drawGraph;

    protected AbstractPipelineTrigger(List<T> editors, DrawGraph drawGraph) {
        Asserts.nullArgument(editors, "editors");
        Asserts.nullArgument(drawGraph, "drawGraph");
        this.editors = editors;
        this.drawGraph = drawGraph;
    }

    public void trigger(Function<I, B> brushFactory) {
        Asserts.nullArgument(brushFactory, "brushFactory");
        for (I item : this.renderItems()) {
            Editor editor;
            Brush brush = (Brush)brushFactory.apply(item);
            Asserts.illegalArgument(brush == null, "BrushFactory cannot create null brush!");
            for (int i = 0; i < this.editors.size() && (editor = (Editor)this.editors.get(i)).edit(item, brush); ++i) {
            }
        }
    }

    protected abstract Iterable<I> renderItems();
}

