/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.draw;

import org.graphper.api.GraphResource;
import org.graphper.api.Graphviz;
import org.graphper.api.attributes.Layout;
import org.graphper.draw.DrawGraph;
import org.graphper.draw.ExecuteException;
import org.graphper.draw.RenderEngine;
import org.graphper.layout.LayoutEngine;
import org.graphper.util.Asserts;

public abstract class AbstractRenderEngine
implements RenderEngine {
    @Override
    public GraphResource render(Graphviz graphviz, Object attach) throws ExecuteException {
        Asserts.nullArgument(graphviz, "graphviz");
        Layout layout = graphviz.graphAttrs().getLayout();
        layout = layout == null ? Layout.DOT : layout;
        try {
            LayoutEngine layoutEngine = layout.getLayoutEngine();
            DrawGraph drawGraph = layoutEngine.layout(graphviz, this);
            drawGraph.setAttach(attach);
            return this.render0(drawGraph);
        }
        catch (Exception e) {
            throw new ExecuteException("Layout engine execute error: ", e);
        }
    }

    protected abstract GraphResource render0(DrawGraph var1) throws ExecuteException;
}

