/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.draw;

import java.io.Serializable;
import org.graphper.api.Assemble;
import org.graphper.api.Html;
import org.graphper.api.attributes.Labelloc;
import org.graphper.api.attributes.NodeShape;
import org.graphper.api.attributes.NodeShapeEnum;
import org.graphper.api.ext.ShapePosition;
import org.graphper.def.FlatPoint;
import org.graphper.draw.ClusterDrawProp;
import org.graphper.draw.NodeDrawProp;
import org.graphper.draw.Rectangle;
import org.graphper.layout.HtmlConvert;
import org.graphper.util.Asserts;

public abstract class ContainerDrawProp
extends Rectangle
implements ShapePosition,
Serializable {
    private static final long serialVersionUID = 621795484015917002L;
    private String id;
    protected FlatPoint labelCenter;
    protected FlatPoint labelSize;
    protected Assemble assemble;

    public double topLowestHeight() {
        Asserts.nullArgument(this.margin(), "margin");
        Asserts.nullArgument((Object)this.labelloc(), "labelloc");
        if (this.labelSize == null || this.labelloc() != Labelloc.TOP) {
            return this.getVerMargin();
        }
        return Math.max(this.getVerMargin(), this.labelSize.getHeight());
    }

    public double bottomLowestHeight() {
        Asserts.nullArgument(this.margin(), "margin");
        Asserts.nullArgument((Object)this.labelloc(), "labelloc");
        if (this.labelSize == null || this.labelloc() != Labelloc.BOTTOM) {
            return this.getVerMargin();
        }
        return Math.max(this.getVerMargin(), this.labelSize.getHeight());
    }

    public double getHorMargin() {
        FlatPoint margin = this.margin();
        return margin.getWidth();
    }

    public double getVerMargin() {
        FlatPoint margin = this.margin();
        return margin.getHeight();
    }

    public void setId(String id) {
        this.id = id;
    }

    public String id() {
        return this.containerId() == null ? this.id : this.containerId();
    }

    public FlatPoint getLabelCenter() {
        return this.labelCenter;
    }

    public void setLabelCenter(FlatPoint labelCenter) {
        this.labelCenter = labelCenter;
    }

    public void setLabelSize(FlatPoint labelSize) {
        this.labelSize = labelSize;
    }

    public FlatPoint getLabelSize() {
        return this.labelSize;
    }

    public Assemble getAssemble() {
        if (this.assemble() != null) {
            return this.assemble();
        }
        return this.assemble;
    }

    @Override
    public double getX() {
        return (this.leftBorder + this.rightBorder) / 2.0;
    }

    @Override
    public double getY() {
        return (this.upBorder + this.downBorder) / 2.0;
    }

    @Override
    public double getHeight() {
        return Math.abs(this.downBorder - this.upBorder);
    }

    @Override
    public double getWidth() {
        return Math.abs(this.rightBorder - this.leftBorder);
    }

    @Override
    public NodeShape nodeShape() {
        return NodeShapeEnum.RECT;
    }

    @Override
    public void flip() {
        super.flip();
        if (this.labelSize != null && !this.isNodeProp()) {
            this.labelSize.flip();
        }
    }

    public boolean isNodeProp() {
        return this instanceof NodeDrawProp;
    }

    public boolean isClusterProp() {
        return this instanceof ClusterDrawProp;
    }

    protected void convertTable(Html.Table table) {
        if (table == null) {
            return;
        }
        this.assemble = HtmlConvert.toAssemble(table);
    }

    protected abstract Labelloc labelloc();

    protected abstract FlatPoint margin();

    protected abstract String containerId();

    protected abstract Assemble assemble();
}

