/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.draw;

import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.graphper.draw.NodeDrawProp;
import org.graphper.draw.svg.SvgBrush;
import org.graphper.util.Asserts;

public abstract class CustomizeShapeRender {
    private static volatile Map<String, CustomizeShapeRender> CUSTOMIZE_REGISTER;

    public static void register(CustomizeShapeRender customizeShapeRender) {
        Asserts.nullArgument(customizeShapeRender, "custimizeNodeShape");
        Asserts.illegalArgument(customizeShapeRender.getShapeName() == null, "CustimizeNodeShape can not return null shapeName");
        CustomizeShapeRender.customizeNodeShapeMap().computeIfAbsent(customizeShapeRender.getShapeName(), s -> customizeShapeRender);
    }

    public static CustomizeShapeRender getCustomizeShapeRender(String shapeName) {
        if (CUSTOMIZE_REGISTER == null) {
            return null;
        }
        return CUSTOMIZE_REGISTER.get(shapeName);
    }

    public static boolean registered(String shapeName) {
        return CustomizeShapeRender.getCustomizeShapeRender(shapeName) != null;
    }

    public abstract String getShapeName();

    public abstract void drawSvg(SvgBrush var1, NodeDrawProp var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<String, CustomizeShapeRender> customizeNodeShapeMap() {
        if (CUSTOMIZE_REGISTER != null) return CUSTOMIZE_REGISTER;
        Class<CustomizeShapeRender> clazz = CustomizeShapeRender.class;
        synchronized (CustomizeShapeRender.class) {
            if (CUSTOMIZE_REGISTER != null) return CUSTOMIZE_REGISTER;
            CUSTOMIZE_REGISTER = new ConcurrentHashMap<String, CustomizeShapeRender>();
            // ** MonitorExit[var0] (shouldn't be in output)
            return CUSTOMIZE_REGISTER;
        }
    }

    static {
        ServiceLoader<CustomizeShapeRender> customizeShapeRenders = ServiceLoader.load(CustomizeShapeRender.class);
        for (CustomizeShapeRender customizeShapeRender : customizeShapeRenders) {
            CustomizeShapeRender.register(customizeShapeRender);
        }
    }
}

