/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.draw;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache_gs.commons.lang3.StringUtils;
import org.graphper.api.GraphResource;
import org.graphper.util.Asserts;

public class DefaultGraphResource
implements GraphResource {
    private final String name;
    private final String suffix;
    private final ByteArrayOutputStream os;

    public DefaultGraphResource(String name, String suffix, ByteArrayOutputStream os) {
        Asserts.nullArgument(os, "Output stream");
        this.name = name;
        this.suffix = suffix;
        this.os = os;
    }

    @Override
    public byte[] bytes() {
        return this.os.toByteArray();
    }

    @Override
    public InputStream inputStream() {
        return new ByteArrayInputStream(this.os.toByteArray());
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String suffix() {
        return "." + this.suffix;
    }

    @Override
    public void save(String parentPath, String fileName) throws IOException {
        fileName = StringUtils.isNotEmpty(fileName) ? fileName : this.name();
        try (FileOutputStream fos = new FileOutputStream(parentPath + File.separator + fileName + this.suffix());){
            fos.write(this.bytes());
            fos.flush();
        }
    }

    @Override
    public void close() throws IOException {
        this.os.reset();
        this.os.close();
    }
}

