/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.draw;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.graphper.api.Cluster;
import org.graphper.api.Graphviz;
import org.graphper.api.Line;
import org.graphper.api.LineAttrs;
import org.graphper.api.Node;
import org.graphper.api.attributes.Layout;
import org.graphper.api.attributes.Rankdir;
import org.graphper.def.BiConcatIterable;
import org.graphper.draw.ClusterDrawProp;
import org.graphper.draw.GraphvizDrawProp;
import org.graphper.draw.LineDrawProp;
import org.graphper.draw.NodeDrawProp;
import org.graphper.draw.Rectangle;
import org.graphper.util.Asserts;

public class DrawGraph
extends Rectangle
implements Serializable {
    private static final long serialVersionUID = -571472079515096134L;
    private static final String NODE_ID_PREFIX = "node_";
    private Object attach;
    private final GraphvizDrawProp graphvizDrawProp;
    private final Map<Node, NodeDrawProp> nodeDrawPropMap;
    private final Map<Line, LineDrawProp> lineDrawPropMap;
    private Map<Cluster, ClusterDrawProp> clusterDrawPropMap;

    public DrawGraph(Graphviz graphviz) {
        Asserts.nullArgument(graphviz, "graphviz");
        this.graphvizDrawProp = new GraphvizDrawProp(graphviz);
        this.nodeDrawPropMap = new LinkedHashMap<Node, NodeDrawProp>();
        this.lineDrawPropMap = new LinkedHashMap<Line, LineDrawProp>();
    }

    public void nodePut(Node node, NodeDrawProp nodeDrawProp) {
        if (node == null || nodeDrawProp == null) {
            return;
        }
        this.nodeDrawPropMap.put(node, nodeDrawProp);
    }

    public void linePut(Line line, LineDrawProp lineDrawProp) {
        if (line == null || lineDrawProp == null || this.lineDrawPropMap == null) {
            return;
        }
        this.lineDrawPropMap.put(line, lineDrawProp);
    }

    public void clusterPut(Cluster cluster, ClusterDrawProp clusterDrawProp) {
        if (cluster == null || clusterDrawProp == null) {
            return;
        }
        if (this.clusterDrawPropMap == null) {
            this.clusterDrawPropMap = new HashMap<Cluster, ClusterDrawProp>(this.graphvizDrawProp.getGraphviz().clusters().size());
        }
        this.clusterDrawPropMap.put(cluster, clusterDrawProp);
    }

    public boolean needFlip() {
        Layout layout = this.getGraphviz().graphAttrs().getLayout();
        Rankdir rankdir = this.getGraphviz().graphAttrs().getRankdir();
        return layout == Layout.DOT && rankdir != Rankdir.TB && rankdir != Rankdir.BT;
    }

    public Graphviz getGraphviz() {
        return this.graphvizDrawProp.getGraphviz();
    }

    public Rankdir rankdir() {
        return this.getGraphviz().graphAttrs().getRankdir();
    }

    public GraphvizDrawProp getGraphvizDrawProp() {
        return this.graphvizDrawProp;
    }

    public Iterable<NodeDrawProp> nodes() {
        return this.nodes(false);
    }

    public Iterable<NodeDrawProp> nodes(boolean filterCell) {
        if (filterCell) {
            return new BiConcatIterable<NodeDrawProp>(NodeDrawProp::isNotCellProp, new Iterable[]{this.nodeDrawPropMap.values()});
        }
        return this.nodeDrawPropMap.values();
    }

    public Collection<LineDrawProp> lines() {
        return this.lineDrawPropMap != null ? this.lineDrawPropMap.values() : Collections.emptyList();
    }

    public Collection<ClusterDrawProp> clusters() {
        return this.clusterDrawPropMap != null ? this.clusterDrawPropMap.values() : Collections.emptyList();
    }

    public NodeDrawProp getNodeDrawProp(Node node) {
        return this.nodeDrawPropMap.get(node);
    }

    public LineDrawProp getLineDrawProp(Line line) {
        if (line == null) {
            return null;
        }
        return this.getLineDrawPropMap().get(line);
    }

    public ClusterDrawProp getClusterDrawProp(Cluster cluster) {
        if (this.clusterDrawPropMap == null) {
            return null;
        }
        return this.clusterDrawPropMap.get(cluster);
    }

    public LineAttrs lineAttrs(Line line) {
        Asserts.nullArgument(line, "line");
        LineDrawProp lineDrawProp = this.getLineDrawPropMap().get(line);
        return lineDrawProp != null ? lineDrawProp.lineAttrs() : line.lineAttrs();
    }

    public Map<Line, LineDrawProp> getLineDrawPropMap() {
        return this.lineDrawPropMap != null ? this.lineDrawPropMap : Collections.emptyMap();
    }

    public double width(Node node) {
        NodeDrawProp nodeDrawProp = this.nodeDrawPropMap.get(node);
        return nodeDrawProp != null ? nodeDrawProp.getWidth() : 0.0;
    }

    public double height(Node node) {
        NodeDrawProp nodeDrawProp = this.nodeDrawPropMap.get(node);
        return nodeDrawProp != null ? nodeDrawProp.getHeight() : 0.0;
    }

    public boolean haveCluster(Cluster cluster) {
        if (this.clusterDrawPropMap == null || cluster == null) {
            return false;
        }
        return this.clusterDrawPropMap.get(cluster) != null;
    }

    public String nodeId(Node node) {
        NodeDrawProp nodeDrawProp = this.nodeDrawPropMap.get(node);
        if (nodeDrawProp == null) {
            return null;
        }
        return nodeDrawProp.nodeAttrs().getId() != null ? nodeDrawProp.nodeAttrs().getId() : NODE_ID_PREFIX + nodeDrawProp.id();
    }

    public int nodeNo(Node node) {
        NodeDrawProp nodeDrawProp = this.nodeDrawPropMap.get(node);
        return nodeDrawProp != null ? nodeDrawProp.nodeNo() : 0;
    }

    public int getNodeNum() {
        return this.nodeDrawPropMap == null ? 0 : this.nodeDrawPropMap.keySet().size();
    }

    public String lineId(Line line) {
        if (this.lineDrawPropMap == null) {
            return null;
        }
        LineDrawProp lineDrawProp = this.lineDrawPropMap.get(line);
        return lineDrawProp != null ? lineDrawProp.id() : null;
    }

    public String clusterId(Cluster cluster) {
        if (this.clusterDrawPropMap == null) {
            return null;
        }
        ClusterDrawProp clusterDrawProp = this.clusterDrawPropMap.get(cluster);
        return clusterDrawProp != null ? clusterDrawProp.id() : null;
    }

    public void syncGraphvizBorder() {
        this.leftBorder = this.graphvizDrawProp.getLeftBorder();
        this.rightBorder = this.graphvizDrawProp.getRightBorder();
        this.upBorder = this.graphvizDrawProp.getUpBorder();
        this.downBorder = this.graphvizDrawProp.getDownBorder();
    }

    public void syncToGraphvizBorder() {
        this.graphvizDrawProp.setLeftBorder(this.leftBorder);
        this.graphvizDrawProp.setRightBorder(this.rightBorder);
        this.graphvizDrawProp.setUpBorder(this.upBorder);
        this.graphvizDrawProp.setDownBorder(this.downBorder);
    }

    public boolean usePortAxisExpander() {
        return Boolean.TRUE.toString().equalsIgnoreCase(System.getProperty("port_axis.node.expander"));
    }

    @Override
    public void updateXAxisRange(double x) {
        super.updateXAxisRange(x);
    }

    @Override
    public void updateYAxisRange(double y) {
        super.updateYAxisRange(y);
    }

    public double getMinX() {
        return this.leftBorder;
    }

    public double getMaxX() {
        return this.rightBorder;
    }

    public double getMinY() {
        return this.upBorder;
    }

    public double getMaxY() {
        return this.downBorder;
    }

    public double width() {
        return this.getMaxX() - this.getMinX();
    }

    public double height() {
        return this.getMaxY() - this.getMinY();
    }

    public Object getAttach() {
        return this.attach;
    }

    public void setAttach(Object attach) {
        this.attach = attach;
    }
}

