/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.draw;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.graphper.api.Assemble;
import org.graphper.api.FloatLabel;
import org.graphper.api.Html;
import org.graphper.api.Line;
import org.graphper.api.LineAttrs;
import org.graphper.api.Node;
import org.graphper.def.FlatPoint;
import org.graphper.def.Vectors;
import org.graphper.draw.ArrowDrawProp;
import org.graphper.draw.DrawGraph;
import org.graphper.layout.HtmlConvert;
import org.graphper.layout.dot.RouterBox;
import org.graphper.util.Asserts;
import org.graphper.util.CollectionUtils;

public class LineDrawProp
extends ArrayList<FlatPoint>
implements Serializable {
    private static final long serialVersionUID = 5529902024948360413L;
    private boolean isHeadStart;
    private final DrawGraph drawGraph;
    private final Line line;
    private FlatPoint start;
    private FlatPoint end;
    private FlatPoint labelCenter;
    private ArrowDrawProp arrowHead;
    private ArrowDrawProp arrowTail;
    private final LineAttrs lineAttrs;
    private String id;
    private boolean isBesselCurve;
    private HashMap<FloatLabel, FlatPoint> floatLabelFlatCenters;
    private List<RouterBox> routerBoxes;
    private Assemble assemble;
    private Map<FloatLabel, Assemble> floatAssembles;

    public LineDrawProp(Line line, LineAttrs lineAttrs, DrawGraph drawGraph) {
        Asserts.nullArgument(line, "line");
        Asserts.nullArgument(lineAttrs, "lineAttrs");
        Asserts.nullArgument(drawGraph, "drawGraph");
        this.line = line;
        this.lineAttrs = lineAttrs;
        this.drawGraph = drawGraph;
        this.convertTables();
    }

    @Override
    public boolean addAll(Collection<? extends FlatPoint> c) {
        if (CollectionUtils.isEmpty(c)) {
            return false;
        }
        for (FlatPoint flatPoint : c) {
            this.add(flatPoint);
        }
        return true;
    }

    @Override
    public boolean add(FlatPoint point) {
        if (super.add(point)) {
            this.refreshDrawGraphArea(point);
            return true;
        }
        return false;
    }

    @Override
    public void add(int index, FlatPoint point) {
        super.add(index, point);
        this.refreshDrawGraphArea(point);
    }

    @Override
    public FlatPoint set(int index, FlatPoint point) {
        FlatPoint p = super.set(index, point);
        this.refreshDrawGraphArea(point);
        return p;
    }

    public boolean addAndNotRefreshDrawGraph(FlatPoint point) {
        return super.add(point);
    }

    public void addFloatLabelCenter(FloatLabel floatLabel, FlatPoint center) {
        if (floatLabel == null || center == null) {
            return;
        }
        if (this.floatLabelFlatCenters == null) {
            this.floatLabelFlatCenters = new HashMap();
        }
        this.floatLabelFlatCenters.put(floatLabel, center);
    }

    private void refreshDrawGraphArea(FlatPoint point) {
        if (point != null) {
            this.drawGraph.updateXAxisRange(point.getX() - 10.0);
            this.drawGraph.updateXAxisRange(point.getX() + 10.0);
            this.drawGraph.updateYAxisRange(point.getY() - 10.0);
            this.drawGraph.updateYAxisRange(point.getY() + 10.0);
        }
    }

    public String id() {
        return this.lineAttrs.getId() != null ? this.lineAttrs.getId() : this.id;
    }

    public Line getLine() {
        return this.line;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public FlatPoint getStart() {
        return this.start;
    }

    public void setStart(FlatPoint start) {
        this.start = start;
    }

    public FlatPoint getEnd() {
        return this.end;
    }

    public void setEnd(FlatPoint end) {
        this.end = end;
    }

    public ArrowDrawProp getArrowHead() {
        return this.arrowHead;
    }

    public void setArrowHead(ArrowDrawProp arrowHead) {
        this.arrowHead = arrowHead;
    }

    public ArrowDrawProp getArrowTail() {
        return this.arrowTail;
    }

    public void setArrowTail(ArrowDrawProp arrowTail) {
        this.arrowTail = arrowTail;
    }

    public FlatPoint getLabelCenter() {
        return this.labelCenter;
    }

    public void setLabelCenter(FlatPoint labelCenter) {
        this.labelCenter = labelCenter;
    }

    public LineAttrs lineAttrs() {
        return this.lineAttrs;
    }

    public boolean isBesselCurve() {
        return this.isBesselCurve;
    }

    public void markIsBesselCurve() {
        this.isBesselCurve = true;
    }

    public void markIsLineSegment() {
        this.isBesselCurve = false;
    }

    public List<RouterBox> getBoxes() {
        return this.routerBoxes;
    }

    public void setBoxes(List<RouterBox> routerBoxes) {
        this.routerBoxes = routerBoxes;
    }

    public Map<FloatLabel, FlatPoint> getFloatLabelFlatCenters() {
        return this.floatLabelFlatCenters != null ? this.floatLabelFlatCenters : Collections.emptyMap();
    }

    public void fakeInit() {
        this.start = Vectors.ZERO;
        this.end = Vectors.ZERO;
    }

    public boolean isSelfLoop() {
        return this.line.tail() == this.line.head();
    }

    public boolean isInit() {
        return this.start != null && this.end != null;
    }

    public boolean isHeadStart() {
        return this.isHeadStart;
    }

    public void setIsHeadStart(Node node) {
        if (node == null) {
            return;
        }
        this.isHeadStart = node == this.getLine().head();
    }

    public Assemble getAssemble() {
        if (this.lineAttrs.getAssemble() != null) {
            return this.lineAttrs.getAssemble();
        }
        return this.assemble;
    }

    public Iterable<Assemble> getFloatAssembles() {
        if (this.floatAssembles == null) {
            return Collections.emptyList();
        }
        return this.floatAssembles.values();
    }

    public Assemble getFloatAssemble(FloatLabel floatLabel) {
        if (this.floatAssembles == null || floatLabel == null) {
            return null;
        }
        return this.floatAssembles.get(floatLabel);
    }

    private void convertTables() {
        FloatLabel[] floatLabels;
        Html.Table table = this.lineAttrs.getTable();
        if (table != null) {
            this.assemble = HtmlConvert.toAssemble(table);
        }
        if ((floatLabels = this.lineAttrs.getFloatLabels()) == null) {
            return;
        }
        for (FloatLabel floatLabel : floatLabels) {
            Assemble floatLabelAssemble = floatLabel.getAssemble();
            if (floatLabelAssemble == null && floatLabel.getTable() != null) {
                floatLabelAssemble = HtmlConvert.toAssemble(floatLabel.getTable());
            }
            if (floatLabelAssemble == null) continue;
            if (this.floatAssembles == null) {
                this.floatAssembles = new HashMap<FloatLabel, Assemble>();
            }
            this.floatAssembles.put(floatLabel, floatLabelAssemble);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LineDrawProp that = (LineDrawProp)o;
        return this.isBesselCurve == that.isBesselCurve && Objects.equals(this.line, that.line) && Objects.equals(this.start, that.start) && Objects.equals(this.end, that.end) && Objects.equals(this.labelCenter, that.labelCenter) && Objects.equals(this.arrowHead, that.arrowHead) && Objects.equals(this.arrowTail, that.arrowTail) && Objects.equals(this.lineAttrs, that.lineAttrs) && Objects.equals(this.id, that.id) && Objects.equals(this.routerBoxes, that.routerBoxes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.line, this.start, this.end, this.labelCenter, this.arrowHead, this.arrowTail, this.lineAttrs, this.id, this.isBesselCurve, this.routerBoxes);
    }

    @Override
    public String toString() {
        return "LineDrawProp{line=" + this.line + ", start=" + this.start + ", end=" + this.end + ", labelCenter=" + this.labelCenter + ", arrowHead=" + this.arrowHead + ", arrowTail=" + this.arrowTail + ", lineAttrs=" + this.lineAttrs + ", id='" + this.id + '\'' + ", isBesselCurve=" + this.isBesselCurve + ", routerBoxes=" + this.routerBoxes + '}';
    }
}

