/*
 * Decompiled with CFR 0.152.
 */
package org.graphper.draw;

import java.io.Serializable;
import org.graphper.api.Assemble;
import org.graphper.api.Node;
import org.graphper.api.NodeAttrs;
import org.graphper.api.attributes.Labelloc;
import org.graphper.api.attributes.NodeShape;
import org.graphper.api.attributes.Rankdir;
import org.graphper.def.FlatPoint;
import org.graphper.draw.ContainerDrawProp;
import org.graphper.layout.Cell;
import org.graphper.util.Asserts;

public class NodeDrawProp
extends ContainerDrawProp
implements Serializable {
    private static final long serialVersionUID = 2785583326128769032L;
    private NodeAttrs nodeAttrs;
    private int id;
    private final Node node;
    private final FlatPoint margin;
    private double labelHorOffset;
    private double labelVerOffset;
    private Cell.RootCell Cell;
    private boolean isCellProp;
    private ContainerDrawProp cellContainer;

    public NodeDrawProp(Node node, NodeAttrs nodeAttrs) {
        Asserts.nullArgument(node, "node");
        Asserts.nullArgument(node, "nodeAttrs");
        this.node = node;
        this.nodeAttrs = nodeAttrs;
        this.margin = nodeAttrs.getMargin();
        this.convertTable(nodeAttrs.getTable());
    }

    public Node getNode() {
        return this.node;
    }

    public void setNodeAttrs(NodeAttrs nodeAttrs) {
        Asserts.nullArgument(nodeAttrs, "nodeAttrs");
        this.nodeAttrs = nodeAttrs;
    }

    public NodeAttrs nodeAttrs() {
        return this.nodeAttrs;
    }

    @Override
    public String id() {
        return String.valueOf(this.id);
    }

    public int nodeNo() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    protected Labelloc labelloc() {
        return this.nodeAttrs.getLabelloc();
    }

    @Override
    protected FlatPoint margin() {
        return this.margin;
    }

    @Override
    protected String containerId() {
        return String.valueOf(this.id);
    }

    @Override
    protected Assemble assemble() {
        return this.nodeAttrs.getAssemble();
    }

    @Override
    public NodeShape nodeShape() {
        return this.nodeAttrs.getNodeShape();
    }

    public double getLabelHorOffset() {
        return this.labelHorOffset;
    }

    public void setLabelHorOffset(double labelHorOffset) {
        this.labelHorOffset = labelHorOffset;
    }

    public double getLabelVerOffset() {
        return this.labelVerOffset;
    }

    public void setLabelVerOffset(double labelVerOffset) {
        this.labelVerOffset = labelVerOffset;
    }

    public Cell.RootCell getCell() {
        return this.Cell;
    }

    public void setCell(Cell.RootCell Cell2) {
        this.Cell = Cell2;
    }

    public void setCellContainer(NodeDrawProp cellContainer) {
        this.cellContainer = cellContainer;
    }

    public boolean haveChildrenCell() {
        return this.getAssemble() != null;
    }

    public boolean noChildrenCell() {
        return !this.haveChildrenCell();
    }

    public void markIsCellProp() {
        this.isCellProp = true;
    }

    public boolean isCellProp() {
        return this.isCellProp;
    }

    public boolean isNotCellProp() {
        return !this.isCellProp();
    }

    public void initCellPos() {
        if (!this.isCellProp()) {
            return;
        }
        FlatPoint ls = this.cellContainer.getLabelSize();
        FlatPoint lc = this.cellContainer.getLabelCenter();
        Assemble assemble = this.cellContainer.getAssemble();
        if (assemble == null) {
            return;
        }
        this.initCellPos(ls, lc, assemble);
    }

    public void initCellPos(FlatPoint ls, FlatPoint lc, Assemble assemble) {
        Asserts.illegalArgument(lc == null || ls == null || assemble == null, "Cell container properties error");
        double width = this.getWidth();
        double height = this.getHeight();
        double horOffset = assemble.horOffset(this.node);
        double verOffset = assemble.verOffset(this.node);
        this.setLeftBorder(lc.getX() - ls.getWidth() / 2.0 + horOffset);
        this.setRightBorder(this.getLeftBorder() + width);
        this.setUpBorder(lc.getY() - ls.getHeight() / 2.0 + verOffset);
        this.setDownBorder(this.getUpBorder() + height);
    }

    public void flip(Rankdir rankdir) {
        if (this.getCell() != null) {
            this.getCell().flip(rankdir, this);
        }
        if (rankdir == Rankdir.LR || rankdir == Rankdir.RL) {
            this.flip();
        }
    }
}

